/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.Socket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSClientSocketSize {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSClientSocketSize.class);

    @Test
    public void testDefaultSendBufferSize() throws IOException {
        int sendBufferSize = this.getSendBufferSize(new Configuration());
        LOG.info("If not specified, the auto tuned send buffer size is: {}", (Object)sendBufferSize);
        Assert.assertTrue((String)"Send buffer size should be non-negative value which is determined by system (kernel).", (sendBufferSize > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSpecifiedSendBufferSize() throws IOException {
        Configuration conf1 = new Configuration();
        conf1.setInt("dfs.client.socket.send.buffer.size", 262144);
        int sendBufferSize1 = this.getSendBufferSize(conf1);
        Configuration conf2 = new Configuration();
        conf2.setInt("dfs.client.socket.send.buffer.size", 1024);
        int sendBufferSize2 = this.getSendBufferSize(conf2);
        LOG.info("Large buf size is {}, small is {}", (Object)sendBufferSize1, (Object)sendBufferSize2);
        Assert.assertTrue((String)"Larger specified send buffer should have effect", (sendBufferSize1 > sendBufferSize2 ? 1 : 0) != 0);
    }

    @Test
    public void testAutoTuningSendBufferSize() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.client.socket.send.buffer.size", 0);
        int sendBufferSize = this.getSendBufferSize(conf);
        LOG.info("The auto tuned send buffer size is: {}", (Object)sendBufferSize);
        Assert.assertTrue((String)"Send buffer size should be non-negative value which is determined by system (kernel).", (sendBufferSize > 0 ? 1 : 0) != 0);
    }

    /*
     * Loose catch block
     */
    private int getSendBufferSize(Configuration conf) throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            LOG.info("MiniDFSCluster started.");
            try (Socket socket = DataStreamer.createSocketForPipeline((DatanodeInfo)new DatanodeInfo.DatanodeInfoBuilder().setNodeID(cluster.dataNodes.get((int)0).datanode.getDatanodeId()).build(), (int)1, (DFSClient)cluster.getFileSystem().getClient());){
                int n = socket.getSendBufferSize();
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.ALL);
    }
}

