/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupRestoreConstants;
import org.apache.hadoop.hbase.backup.impl.BackupAdminImpl;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RestoreDriver
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreDriver.class);
    private CommandLine cmd;
    private static final String USAGE_STRING = "Usage: hbase restore <backup_path> <backup_id> [options]\n  backup_path     Path to a backup destination root\n  backup_id       Backup image ID to restore\n  table(s)        Comma-separated list of tables to restore\n";
    private static final String USAGE_FOOTER = "";

    protected RestoreDriver() throws IOException {
        this.init();
    }

    protected void init() {
        Log4jUtils.disableZkAndClientLoggers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int parseAndRun() throws IOException {
        String[] remainArgs;
        boolean check;
        boolean overwrite;
        if (!BackupManager.isBackupEnabled(this.getConf())) {
            System.err.println(BackupRestoreConstants.ENABLE_BACKUP);
            return -1;
        }
        if (this.cmd.hasOption("d")) {
            Log4jUtils.setLogLevel((String)"org.apache.hadoop.hbase.backup", (String)"DEBUG");
        }
        if (overwrite = this.cmd.hasOption("o")) {
            LOG.debug("Found -overwrite option in restore command, will overwrite to existing table if any in the restore target");
        }
        if (check = this.cmd.hasOption("c")) {
            LOG.debug("Found -check option in restore command, will check and verify the dependencies");
        }
        if (this.cmd.hasOption("s") && this.cmd.hasOption("t")) {
            System.err.println("Options -s and -t are mutaully exclusive, you can not specify both of them.");
            this.printToolUsage();
            return -1;
        }
        if (!this.cmd.hasOption("s") && !this.cmd.hasOption("t")) {
            System.err.println("You have to specify either set name or table list to restore");
            this.printToolUsage();
            return -1;
        }
        if (this.cmd.hasOption("q")) {
            String queueName = this.cmd.getOptionValue("q");
            this.getConf().set("mapreduce.job.queuename", queueName);
        }
        if ((remainArgs = this.cmd.getArgs()).length != 2) {
            this.printToolUsage();
            return -1;
        }
        String backupRootDir = remainArgs[0];
        String backupId = remainArgs[1];
        String tableMapping = this.cmd.hasOption("m") ? this.cmd.getOptionValue("m") : null;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
             BackupAdminImpl client = new BackupAdminImpl(conn);){
            String tables;
            if (this.cmd.hasOption("s")) {
                String setName = this.cmd.getOptionValue("s");
                try {
                    tables = this.getTablesForSet(conn, setName);
                }
                catch (IOException e) {
                    System.out.println("ERROR: " + e.getMessage() + " for setName=" + setName);
                    this.printToolUsage();
                    int n = -2;
                    if (client != null) {
                        if (var11_13 != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable) {
                                var11_13.addSuppressed(throwable);
                            }
                        } else {
                            client.close();
                        }
                    }
                    if (conn == null) return n;
                    if (var9_9 == null) {
                        conn.close();
                        return n;
                    }
                    try {
                        conn.close();
                        return n;
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                        return n;
                    }
                }
                if (tables == null) {
                    System.out.println("ERROR: Backup set '" + setName + "' is either empty or does not exist");
                    this.printToolUsage();
                    int e = -3;
                    return e;
                }
            } else {
                tables = this.cmd.getOptionValue("t");
            }
            TableName[] sTableArray = BackupUtils.parseTableNames(tables);
            TableName[] tTableArray = BackupUtils.parseTableNames(tableMapping);
            if (sTableArray != null && tTableArray != null && sTableArray.length != tTableArray.length) {
                System.out.println("ERROR: table mapping mismatch: " + tables + " : " + tableMapping);
                this.printToolUsage();
                int n = -4;
                return n;
            }
            client.restore(BackupUtils.createRestoreRequest(backupRootDir, backupId, check, sTableArray, tTableArray, overwrite));
            return 0;
        }
        catch (Exception e) {
            LOG.error("Error while running restore backup", (Throwable)e);
            return -5;
        }
    }

    private String getTablesForSet(Connection conn, String name) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(conn);){
            List<TableName> tables = table.describeBackupSet(name);
            if (tables == null) {
                String string = null;
                return string;
            }
            String string = StringUtils.join(tables, (String)",");
            return string;
        }
    }

    protected void addOptions() {
        this.addOptNoArg("o", "Overwrite data if any of the restore target tables exists");
        this.addOptNoArg("c", "Check restore sequence and dependencies only (does not execute the command)");
        this.addOptNoArg("d", "Enable debug loggings");
        this.addOptWithArg("s", "Backup set to restore, mutually exclusive with -t (table list)");
        this.addOptWithArg("t", "Table name list, comma-separated.");
        this.addOptWithArg("m", "A comma separated list of target tables. If specified, each table in <tables> must have a mapping");
        this.addOptWithArg("q", "Yarn queue name to run backup restore command on");
    }

    protected void processOptions(CommandLine cmd) {
        this.cmd = cmd;
    }

    protected int doWork() throws Exception {
        return this.parseAndRun();
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Path hbasedir = CommonFSUtils.getRootDir((Configuration)conf);
        URI defaultFs = hbasedir.getFileSystem(conf).getUri();
        CommonFSUtils.setFsDefault((Configuration)conf, (Path)new Path(defaultFs));
        int ret = ToolRunner.run((Configuration)conf, (Tool)new RestoreDriver(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) {
        CommandLine cmd;
        Objects.requireNonNull(this.conf, "Tool configuration is not initialized");
        try {
            cmd = this.parseArgs(args);
            this.cmdLineArgs = args;
        }
        catch (Exception e) {
            System.out.println("Error when parsing command-line arguments: " + e.getMessage());
            this.printToolUsage();
            return 1;
        }
        if (cmd.hasOption("h") || cmd.hasOption("help")) {
            this.printToolUsage();
            return 1;
        }
        this.processOptions(cmd);
        int ret = 1;
        try {
            ret = this.doWork();
        }
        catch (Exception e) {
            LOG.error("Error running command-line tool", (Throwable)e);
            return 1;
        }
        return ret;
    }

    protected void printToolUsage() {
        System.out.println(USAGE_STRING);
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setLeftPadding(2);
        helpFormatter.setDescPadding(8);
        helpFormatter.setWidth(100);
        helpFormatter.setSyntaxPrefix("Options:");
        helpFormatter.printHelp(" ", null, this.options, USAGE_FOOTER);
        System.out.println(BackupRestoreConstants.VERIFY_BACKUP);
    }
}

