/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.constants;

import org.apache.directory.api.util.Strings;

public enum LdapSecurityConstants {
    HASH_METHOD_SHA("SHA", "SHA", "sha"),
    HASH_METHOD_SSHA("SSHA", "SHA", "ssha"),
    HASH_METHOD_SHA256("SHA-256", "SHA-256", "sha256"),
    HASH_METHOD_SSHA256("SSHA-256", "SHA-256", "ssha256"),
    HASH_METHOD_SHA384("SHA-384", "SHA-384", "sha384"),
    HASH_METHOD_SSHA384("SSHA-384", "SHA-384", "ssha384"),
    HASH_METHOD_SHA512("SHA-512", "SHA-512", "sha512"),
    HASH_METHOD_SSHA512("SSHA-512", "SHA-512", "ssha512"),
    HASH_METHOD_MD5("MD5", "MD5", "md5"),
    HASH_METHOD_SMD5("SMD5", "MD5", "smd5"),
    HASH_METHOD_CRYPT("CRYPT", "CRYPT", "crypt");

    private String name;
    private String algorithm;
    private String prefix;

    private LdapSecurityConstants(String name, String algorithm, String prefix) {
        this.name = name;
        this.algorithm = algorithm;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static LdapSecurityConstants getAlgorithm(String name) {
        String algorithm = "";
        if (name != null) {
            algorithm = Strings.toLowerCase(name);
        }
        if (HASH_METHOD_SHA.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SHA.getPrefix().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA;
        }
        if (HASH_METHOD_SSHA.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SSHA.getPrefix().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA;
        }
        if (HASH_METHOD_MD5.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_MD5.getPrefix().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_MD5;
        }
        if (HASH_METHOD_SMD5.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SMD5.getPrefix().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SMD5;
        }
        if (HASH_METHOD_CRYPT.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_CRYPT.getPrefix().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_CRYPT;
        }
        if (HASH_METHOD_SHA256.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SHA256.getPrefix().equalsIgnoreCase(algorithm) || "sha-256".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA256;
        }
        if (HASH_METHOD_SSHA256.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SSHA256.getPrefix().equalsIgnoreCase(algorithm) || "ssha-256".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA256;
        }
        if (HASH_METHOD_SHA384.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SHA384.getPrefix().equalsIgnoreCase(algorithm) || "sha-384".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA384;
        }
        if (HASH_METHOD_SSHA384.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SSHA384.getPrefix().equalsIgnoreCase(algorithm) || "ssha-384".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA384;
        }
        if (HASH_METHOD_SHA512.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SHA512.getPrefix().equalsIgnoreCase(algorithm) || "sha-512".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA512;
        }
        if (HASH_METHOD_SSHA512.getName().equalsIgnoreCase(algorithm) || HASH_METHOD_SSHA512.getPrefix().equalsIgnoreCase(algorithm) || "ssha-512".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA512;
        }
        return null;
    }
}

