/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MapReduceTests.class, MediumTests.class})
public class TestWALInputFormat {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALInputFormat.class);

    @BeforeClass
    public static void setupClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.createWALRootDir();
    }

    @Test
    public void testAddFile() {
        ArrayList lfss = new ArrayList();
        LocatedFileStatus lfs = (LocatedFileStatus)Mockito.mock(LocatedFileStatus.class);
        long now = EnvironmentEdgeManager.currentTime();
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name." + now));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)now, (long)now);
        Assert.assertEquals((long)1L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now - 1L), (long)(now - 1L));
        Assert.assertEquals((long)1L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now - 2L), (long)(now - 1L));
        Assert.assertEquals((long)1L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now - 2L), (long)now);
        Assert.assertEquals((long)2L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)now);
        Assert.assertEquals((long)3L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)4L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)now, (long)(now + 2L));
        Assert.assertEquals((long)5L, (long)lfss.size());
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)(now + 1L), (long)(now + 2L));
        Assert.assertEquals((long)5L, (long)lfss.size());
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name"));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)6L, (long)lfss.size());
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name.123"));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)7L, (long)lfss.size());
        Mockito.when((Object)lfs.getPath()).thenReturn((Object)new Path("/name." + now + ".meta"));
        WALInputFormat.addFile(lfss, (LocatedFileStatus)lfs, (long)now, (long)now);
        Assert.assertEquals((long)8L, (long)lfss.size());
    }

    @Test
    public void testHandlesArchivedWALFiles() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        JobContext ctx = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)ctx.getConfiguration()).thenReturn((Object)conf);
        Job job = Job.getInstance((Configuration)conf);
        TableMapReduceUtil.initCredentialsForCluster((Job)job, (Configuration)conf);
        Mockito.when((Object)ctx.getCredentials()).thenReturn((Object)job.getCredentials());
        HRegionServer rs = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        AbstractFSWAL wal = (AbstractFSWAL)rs.getWALs().get(0);
        Path walPath = wal.getCurrentFileName();
        TEST_UTIL.getConfiguration().set("mapreduce.input.fileinputformat.inputdir", walPath.toString());
        TEST_UTIL.getConfiguration().set("wal.input.separator", ";");
        Path rootDir = CommonFSUtils.getWALRootDir((Configuration)conf);
        Path archiveWal = new Path(rootDir, "oldWALs");
        archiveWal = new Path(archiveWal, walPath.getName());
        TEST_UTIL.getTestFileSystem().delete(walPath, true);
        TEST_UTIL.getTestFileSystem().mkdirs(archiveWal.getParent());
        TEST_UTIL.getTestFileSystem().create(archiveWal).close();
        WALInputFormat wif = new WALInputFormat();
        List splits = wif.getSplits(ctx);
        Assert.assertEquals((long)1L, (long)splits.size());
        WALInputFormat.WALSplit split = (WALInputFormat.WALSplit)splits.get(0);
        Assert.assertEquals((Object)archiveWal.toString(), (Object)split.getLogFileName());
    }
}

