/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LocatedBlocksRefresher;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocatedBlocksRefresher {
    private static final Logger LOG = LoggerFactory.getLogger(TestLocatedBlocksRefresher.class);
    private static final int BLOCK_SIZE = 0x100000;
    private static final short REPLICATION_FACTOR = 4;
    private static final String[] RACKS = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
    private static final int NUM_DATA_NODES = RACKS.length;
    private final int numOfBlocks = 24;
    private final int fileLength = 0x1800000;
    private final int dfsClientPrefetchSize = 0xC00000;
    private MiniDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.cluster = null;
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
        this.conf.setInt("dfs.replication", 4);
        this.conf.setLong("dfs.blocksize", 0x100000L);
        this.conf.setLong("dfs.client.read.prefetch.size", 0xC00000L);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown(true, true);
        }
    }

    private void setupTest(long refreshInterval) throws IOException {
        this.conf.setLong("dfs.client.refresh.read-block-locations.ms", refreshInterval);
        this.conf.set("dfs.client.context", UUID.randomUUID().toString());
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(NUM_DATA_NODES).racks(RACKS).build();
        this.cluster.waitActive();
    }

    @Test
    public void testDisabledOnZeroInterval() throws IOException {
        this.setupTest(0L);
        Assert.assertNull((Object)this.cluster.getFileSystem().getClient().getLocatedBlockRefresher());
    }

    @Test
    public void testEnabledOnNonZeroInterval() throws Exception {
        this.setupTest(1000L);
        LocatedBlocksRefresher refresher = this.cluster.getFileSystem().getClient().getLocatedBlockRefresher();
        Assert.assertNotNull((Object)refresher);
        this.assertNoMoreRefreshes(refresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshOnDeadNodes() throws Exception {
        this.setupTest(1000L);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSClient client = fs.getClient();
        LocatedBlocksRefresher refresher = client.getLocatedBlockRefresher();
        String fileName = this.createTestFile((FileSystem)fs);
        try (DFSInputStream fin = client.open(fileName);){
            LocatedBlocks locatedBlocks = fin.locatedBlocks;
            Assert.assertEquals((long)12L, (long)locatedBlocks.locatedBlockCount());
            Assert.assertFalse((boolean)refresher.isInputStreamTracked(fin));
            refresher.addInputStream(fin);
            Assert.assertTrue((boolean)refresher.isInputStreamTracked(fin));
            this.assertNoMoreRefreshes(refresher);
            Object object = fin.infoLock;
            synchronized (object) {
                Assert.assertSame((Object)locatedBlocks, (Object)fin.locatedBlocks);
            }
            this.stopNodeHostingBlocks(fin, NUM_DATA_NODES - 1);
            int chunkReadSize = 262144;
            byte[] readBuffer = new byte[chunkReadSize];
            fin.read(0L, readBuffer, 0, readBuffer.length);
            Assert.assertEquals((long)1L, (long)fin.getLocalDeadNodes().size());
            this.assertRefreshes(refresher, 1);
            Object object2 = fin.infoLock;
            synchronized (object2) {
                Assert.assertNotSame((Object)locatedBlocks, (Object)fin.locatedBlocks);
                Assert.assertTrue((boolean)fin.getLocalDeadNodes().isEmpty());
            }
            this.assertNoMoreRefreshes(refresher);
            this.stopNodeHostingBlocks(fin, NUM_DATA_NODES - 2);
            readBuffer = new byte[chunkReadSize];
            fin.read(0L, readBuffer, 0, readBuffer.length);
            Assert.assertTrue((fin.getLocalDeadNodes().size() > 0 ? 1 : 0) != 0);
            this.assertRefreshes(refresher, 1);
            object2 = fin.infoLock;
            synchronized (object2) {
                Assert.assertNotSame((Object)locatedBlocks, (Object)fin.locatedBlocks);
                Assert.assertTrue((boolean)fin.getLocalDeadNodes().isEmpty());
            }
            refresher.removeInputStream(fin);
        }
        this.assertNoMoreRefreshes(refresher);
    }

    private void stopNodeHostingBlocks(DFSInputStream fin, int expectedNodes) {
        Object object = fin.infoLock;
        synchronized (object) {
            int idx = fin.locatedBlocks.findBlock(0L);
            for (int i = 0; i < 4; ++i) {
                String deadNodeAddr = fin.locatedBlocks.get(idx).getLocations()[i].getXferAddr();
                MiniDFSCluster.DataNodeProperties dataNodeProperties = this.cluster.stopDataNode(deadNodeAddr);
                if (dataNodeProperties == null) continue;
                ArrayList<DataNode> datanodesPostStoppage = this.cluster.getDataNodes();
                Assert.assertEquals((long)expectedNodes, (long)datanodesPostStoppage.size());
                return;
            }
            throw new RuntimeException("Could not find a datanode to stop");
        }
    }

    private void assertNoMoreRefreshes(LocatedBlocksRefresher refresher) throws InterruptedException {
        long interval = refresher.getInterval();
        int runCount = refresher.getRunCount();
        int refreshCount = refresher.getRefreshCount();
        LOG.info("Waiting for at least {} runs, from current {}, expecting no refreshes", (Object)(runCount + 3), (Object)runCount);
        this.awaitWithTimeout(() -> refresher.getRunCount() > runCount + 3, 5L * interval);
        Assert.assertEquals((long)refreshCount, (long)refresher.getRefreshCount());
    }

    private void assertRefreshes(LocatedBlocksRefresher refresher, int expectedRefreshes) throws InterruptedException {
        int runCount = refresher.getRunCount();
        int refreshCount = refresher.getRefreshCount();
        int expectedRuns = 3;
        if (expectedRefreshes < 0) {
            expectedRefreshes = expectedRuns;
        }
        LOG.info("Waiting for at least {} runs, from current {}. Expecting {} refreshes, from current {}", new Object[]{runCount + expectedRuns, runCount, refreshCount + expectedRefreshes, refreshCount});
        this.awaitWithTimeout(() -> refresher.getRunCount() >= runCount + expectedRuns, 10000L);
        Assert.assertEquals((long)expectedRefreshes, (long)(refresher.getRefreshCount() - refreshCount));
    }

    private void awaitWithTimeout(Supplier<Boolean> test, long timeoutMillis) throws InterruptedException {
        long now = Time.monotonicNow();
        while (!test.get().booleanValue()) {
            if (Time.monotonicNow() - now > timeoutMillis) {
                Assert.fail((String)"Timed out waiting for true condition");
                return;
            }
            Thread.sleep(50L);
        }
    }

    private String createTestFile(FileSystem fs) throws IOException {
        String fileName = "/located_blocks_" + UUID.randomUUID().toString();
        Path filePath = new Path(fileName);
        try (FSDataOutputStream fout = fs.create(filePath, (short)4);){
            fout.write(new byte[0x1800000]);
        }
        fs.deleteOnExit(filePath);
        return fileName;
    }
}

