/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, SmallTests.class})
public class TestWALConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(TestWALConfiguration.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALConfiguration.class);
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter
    public String walProvider;

    @Parameterized.Parameters(name="{index}: provider={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"filesystem"}, {"asyncfs"});
    }

    @Before
    public void before() {
        TEST_UTIL.getConfiguration().set("hbase.wal.provider", this.walProvider);
    }

    @Test
    public void testBlocksizeDefaultsToTwiceHDFSBlockSize() throws IOException {
        TableName tableName = TableName.valueOf((String)"test");
        WALFactory walFactory = new WALFactory(TEST_UTIL.getConfiguration(), this.walProvider);
        Configuration conf = TEST_UTIL.getConfiguration();
        WALProvider provider = walFactory.getWALProvider();
        WAL wal = provider.getWAL(null);
        if (wal instanceof AbstractFSWAL) {
            long expectedDefaultBlockSize = WALUtil.getWALBlockSize((Configuration)conf, (FileSystem)FileSystem.get((Configuration)conf), (Path)TEST_UTIL.getDataTestDir());
            long blocksize = ((AbstractFSWAL)wal).blocksize;
            Assert.assertEquals((long)expectedDefaultBlockSize, (long)blocksize);
            LOG.info("Found blocksize of {} on {}", (Object)blocksize, (Object)wal);
        } else {
            Assert.fail((String)("Unknown provider " + provider));
        }
    }
}

