/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.postgresql.converter;

import java.sql.SQLException;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;

public class PostgreSqlExceptionConverter
extends JdbcExceptionConverter {
    private static final String DUPLICATE_DATABASE = "42P04";
    private static final String DUPLICATE_SCHEMA = "42P06";
    private static final String DUPLICATE_TABLE = "42P07";
    private static final String INVALID_SCHEMA_NAME = "3D000";
    private static final String INVALID_SCHEMA = "3F000";
    private static final String UNDEFINED_TABLE = "42P01";
    private static final String CONNECTION_EXCEPTION = "08";

    public GravitinoRuntimeException toGravitinoException(SQLException se) {
        if (null != se.getSQLState()) {
            switch (se.getSQLState()) {
                case "42P04": 
                case "42P06": {
                    return new SchemaAlreadyExistsException(se.getMessage(), new Object[]{se});
                }
                case "42P07": {
                    return new TableAlreadyExistsException(se.getMessage(), new Object[]{se});
                }
                case "3D000": 
                case "3F000": {
                    return new NoSuchSchemaException(se.getMessage(), new Object[]{se});
                }
                case "42P01": {
                    return new NoSuchTableException(se.getMessage(), new Object[]{se});
                }
            }
            if (se.getSQLState().startsWith(CONNECTION_EXCEPTION)) {
                return new ConnectionFailedException(se.getMessage(), new Object[]{se});
            }
            return new GravitinoRuntimeException(se.getMessage(), new Object[]{se});
        }
        if (se.getMessage() != null && se.getMessage().contains("password authentication failed")) {
            return new ConnectionFailedException(se.getMessage(), new Object[]{se});
        }
        return new GravitinoRuntimeException(se.getMessage(), new Object[]{se});
    }
}

