/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.nio.channels.ClosedByInterruptException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminTagRetriever
extends RangerTagRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminTagRetriever.class);
    private static final String OPTION_DEDUP_TAGS = "deDupTags";
    private static final Boolean OPTION_DEDUP_TAGS_DEFAULT = true;
    private RangerAdminClient adminClient;
    private boolean deDupTags;

    @Override
    public void init(Map<String, String> options) {
        if (StringUtils.isNotBlank((String)this.serviceName) && this.serviceDef != null && StringUtils.isNotBlank((String)this.appId)) {
            RangerPluginConfig pluginConfig = this.pluginConfig;
            if (pluginConfig == null) {
                pluginConfig = new RangerPluginConfig(this.serviceDef.getName(), this.serviceName, this.appId, null, null, null);
            }
            String deDupTagsVal = options != null ? options.get(OPTION_DEDUP_TAGS) : null;
            RangerPluginContext pluginContext = this.getPluginContext();
            RangerAdminClient rangerAdmin = pluginContext.getAdminClient();
            this.deDupTags = StringUtils.isNotBlank((String)deDupTagsVal) ? Boolean.parseBoolean(deDupTagsVal) : OPTION_DEDUP_TAGS_DEFAULT;
            this.adminClient = rangerAdmin != null ? rangerAdmin : pluginContext.createAdminClient(pluginConfig);
        } else {
            LOG.error("FATAL: Cannot find service/serviceDef to use for retrieving tags. Will NOT be able to retrieve tags.");
        }
    }

    @Override
    public ServiceTags retrieveTags(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags serviceTags = null;
        if (this.adminClient != null) {
            try {
                serviceTags = this.adminClient.getServiceTagsIfUpdated(lastKnownVersion, lastActivationTimeInMillis);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                LOG.error("Tag-retriever thread was interrupted while blocked on I/O");
                throw new InterruptedException();
            }
            catch (Exception e) {
                LOG.error("Tag-retriever encounterd exception, exception=", (Throwable)e);
                LOG.error("Returning null service tags");
            }
        }
        if (serviceTags != null && !serviceTags.getIsDelta().booleanValue() && this.deDupTags) {
            int countOfDuplicateTags = serviceTags.dedupTags();
            LOG.info("Number of duplicate tags removed from the received serviceTags:[" + countOfDuplicateTags + "]. Number of tags in the de-duplicated serviceTags :[" + serviceTags.getTags().size() + "].");
        }
        return serviceTags;
    }
}

