/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.distributed.RetryStrategy;
import co.cask.tephra.distributed.RetryStrategyProvider;
import org.apache.hadoop.conf.Configuration;

public class RetryNTimes
extends RetryStrategy {
    int attempts = 0;
    int limit;

    protected RetryNTimes(int maxAttempts) {
        this.limit = maxAttempts;
    }

    @Override
    boolean failOnce() {
        ++this.attempts;
        return this.attempts < this.limit;
    }

    public static class Provider
    implements RetryStrategyProvider {
        int nTimes = 2;

        @Override
        public void configure(Configuration config) {
            this.nTimes = config.getInt("data.tx.client.retry.attempts", this.nTimes);
        }

        @Override
        public RetryStrategy newRetryStrategy() {
            return new RetryNTimes(this.nTimes);
        }

        public String toString() {
            return this.nTimes + " attempts without delay";
        }
    }
}

