/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.TableMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.TableMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class TableMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, TableMetaBaseSQLProvider> TABLE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new TableMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new TableMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new TableMetaPostgreSQLProvider());

    public static TableMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return TABLE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listTablePOsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return TableMetaSQLProviderFactory.getProvider().listTablePOsBySchemaId(schemaId);
    }

    public static String listTablePOsByTableIds(@Param(value="tableIds") List<Long> tableIds) {
        return TableMetaSQLProviderFactory.getProvider().listTablePOsByTableIds(tableIds);
    }

    public static String selectTableIdBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="tableName") String name) {
        return TableMetaSQLProviderFactory.getProvider().selectTableIdBySchemaIdAndName(schemaId, name);
    }

    public static String selectTableMetaBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="tableName") String name) {
        return TableMetaSQLProviderFactory.getProvider().selectTableMetaBySchemaIdAndName(schemaId, name);
    }

    public static String selectTableMetaById(@Param(value="tableId") Long tableId) {
        return TableMetaSQLProviderFactory.getProvider().selectTableMetaById(tableId);
    }

    public static String insertTableMeta(@Param(value="tableMeta") TablePO tablePO) {
        return TableMetaSQLProviderFactory.getProvider().insertTableMeta(tablePO);
    }

    public static String insertTableMetaOnDuplicateKeyUpdate(@Param(value="tableMeta") TablePO tablePO) {
        return TableMetaSQLProviderFactory.getProvider().insertTableMetaOnDuplicateKeyUpdate(tablePO);
    }

    public static String updateTableMeta(@Param(value="newTableMeta") TablePO newTablePO, @Param(value="oldTableMeta") TablePO oldTablePO, @Param(value="newSchemaId") Long newSchemaId) {
        return TableMetaSQLProviderFactory.getProvider().updateTableMeta(newTablePO, oldTablePO, newSchemaId);
    }

    public static String softDeleteTableMetasByTableId(@Param(value="tableId") Long tableId) {
        return TableMetaSQLProviderFactory.getProvider().softDeleteTableMetasByTableId(tableId);
    }

    public static String softDeleteTableMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return TableMetaSQLProviderFactory.getProvider().softDeleteTableMetasByMetalakeId(metalakeId);
    }

    public static String softDeleteTableMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return TableMetaSQLProviderFactory.getProvider().softDeleteTableMetasByCatalogId(catalogId);
    }

    public static String softDeleteTableMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return TableMetaSQLProviderFactory.getProvider().softDeleteTableMetasBySchemaId(schemaId);
    }

    public static String deleteTableMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return TableMetaSQLProviderFactory.getProvider().deleteTableMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class TableMetaMySQLProvider
    extends TableMetaBaseSQLProvider {
        TableMetaMySQLProvider() {
        }
    }

    static class TableMetaH2Provider
    extends TableMetaBaseSQLProvider {
        TableMetaH2Provider() {
        }
    }
}

