/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.key;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.key.KeyMaker;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;

public abstract class AbstractKeyMaker
implements KeyMaker {
    static final byte[] KERBEROS_CONSTANT = "kerberos".getBytes(StandardCharsets.UTF_8);
    private EncryptProvider encProvider;

    public AbstractKeyMaker(EncryptProvider encProvider) {
        this.encProvider = encProvider;
    }

    public static byte[] makePasswdSalt(String password, String salt) {
        char[] chars = new char[password.length() + salt.length()];
        System.arraycopy(password.toCharArray(), 0, chars, 0, password.length());
        System.arraycopy(salt.toCharArray(), 0, chars, password.length(), salt.length());
        return new String(chars).getBytes(StandardCharsets.UTF_8);
    }

    protected static int getIterCount(byte[] param, int defCount) {
        int iterCount = defCount;
        if (param != null) {
            if (param.length != 4) {
                throw new IllegalArgumentException("Invalid param to str2Key");
            }
            iterCount = BytesUtil.bytes2int(param, 0, true);
        }
        return iterCount;
    }

    protected static byte[] getSaltBytes(String salt, String pepper) {
        byte[] saltBytes = salt.getBytes(StandardCharsets.UTF_8);
        if (pepper != null && !pepper.isEmpty()) {
            byte[] pepperBytes = pepper.getBytes(StandardCharsets.UTF_8);
            int len = saltBytes.length;
            byte[] results = new byte[len += 1 + pepperBytes.length];
            System.arraycopy(pepperBytes, 0, results, 0, pepperBytes.length);
            results[pepperBytes.length] = 0;
            System.arraycopy(saltBytes, 0, results, pepperBytes.length + 1, saltBytes.length);
            return results;
        }
        return saltBytes;
    }

    protected EncryptProvider encProvider() {
        return this.encProvider;
    }

    @Override
    public byte[] random2Key(byte[] randomBits) throws KrbException {
        return new byte[0];
    }
}

