/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.shaded.guava.collect;

import com.lancedb.lance.shaded.guava.annotations.GwtCompatible;
import com.lancedb.lance.shaded.guava.annotations.GwtIncompatible;
import com.lancedb.lance.shaded.guava.annotations.J2ktIncompatible;
import com.lancedb.lance.shaded.guava.base.Preconditions;
import com.lancedb.lance.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import com.lancedb.lance.shaded.guava.collect.ImmutableCollection;
import com.lancedb.lance.shaded.guava.collect.ImmutableMap;
import com.lancedb.lance.shaded.guava.collect.IndexedImmutableSet;
import com.lancedb.lance.shaded.guava.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableMapKeySet<K, V>
extends IndexedImmutableSet<K> {
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public Spliterator<K> spliterator() {
        return this.map.keySpliterator();
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index) {
        return ((Map.Entry)((ImmutableCollection)((Object)this.map.entrySet())).asList().get(index)).getKey();
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        Preconditions.checkNotNull(action);
        this.map.forEach((? super K k, ? super V v) -> action.accept((Object)k));
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    @GwtIncompatible
    @J2ktIncompatible
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

