/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.List;
import java.util.Objects;

public class RewriteGroup {
    private final List<FragmentMetadata> oldFragments;
    private final List<FragmentMetadata> newFragments;

    private RewriteGroup(List<FragmentMetadata> oldFragments, List<FragmentMetadata> newFragments) {
        this.oldFragments = oldFragments;
        this.newFragments = newFragments;
    }

    public List<FragmentMetadata> oldFragments() {
        return this.oldFragments;
    }

    public List<FragmentMetadata> newFragments() {
        return this.newFragments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RewriteGroup that = (RewriteGroup)o;
        return Objects.equals(this.oldFragments, that.oldFragments) && Objects.equals(this.newFragments, that.newFragments);
    }

    public int hashCode() {
        return Objects.hash(this.oldFragments, this.newFragments);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("oldFragments", this.oldFragments).add("newFragments", this.newFragments).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<FragmentMetadata> oldFragments;
        private List<FragmentMetadata> newFragments;

        private Builder() {
        }

        public Builder oldFragments(List<FragmentMetadata> oldFragments) {
            this.oldFragments = oldFragments;
            return this;
        }

        public Builder newFragments(List<FragmentMetadata> newFragments) {
            this.newFragments = newFragments;
            return this;
        }

        public RewriteGroup build() {
            return new RewriteGroup(this.oldFragments, this.newFragments);
        }
    }
}

