/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.operation.Operation;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Delete
implements Operation {
    private final List<FragmentMetadata> updatedFragments;
    private final List<Long> deletedFragmentIds;
    private final String predicate;

    private Delete(List<FragmentMetadata> updatedFragments, List<Long> deletedFragmentIds, String predicate) {
        this.updatedFragments = updatedFragments;
        this.deletedFragmentIds = deletedFragmentIds;
        this.predicate = predicate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<FragmentMetadata> updatedFragments() {
        return this.updatedFragments;
    }

    public List<Long> deletedFragmentIds() {
        return this.deletedFragmentIds;
    }

    public String predicate() {
        return this.predicate;
    }

    @Override
    public String name() {
        return "Delete";
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("updatedFragments", this.updatedFragments).add("deletedFragmentIds", this.deletedFragmentIds).add("predicate", this.predicate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Delete that = (Delete)o;
        return Objects.equals(this.updatedFragments, that.updatedFragments) && Objects.equals(this.deletedFragmentIds, that.deletedFragmentIds) && Objects.equals(this.predicate, that.predicate);
    }

    public static class Builder {
        private List<FragmentMetadata> updatedFragments = Collections.emptyList();
        private List<Long> deletedFragmentIds = Collections.emptyList();
        private String predicate = "";

        private Builder() {
        }

        public Builder updatedFragments(List<FragmentMetadata> updatedFragments) {
            this.updatedFragments = updatedFragments;
            return this;
        }

        public Builder deletedFragmentIds(List<Long> deletedFragmentIds) {
            this.deletedFragmentIds = deletedFragmentIds;
            return this;
        }

        public Builder predicate(String predicate) {
            this.predicate = predicate;
            return this;
        }

        public Delete build() {
            return new Delete(this.updatedFragments, this.deletedFragmentIds, this.predicate);
        }
    }
}

