/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index;

import com.lancedb.lance.index.scalar.ScalarIndexParams;
import com.lancedb.lance.index.vector.VectorIndexParams;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Optional;

public class IndexParams {
    private final Optional<VectorIndexParams> vectorIndexParams;
    private final Optional<ScalarIndexParams> scalarIndexParams;

    private IndexParams(Builder builder) {
        this.vectorIndexParams = builder.vectorIndexParams;
        this.scalarIndexParams = builder.scalarIndexParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<VectorIndexParams> getVectorIndexParams() {
        return this.vectorIndexParams;
    }

    public Optional<ScalarIndexParams> getScalarIndexParams() {
        return this.scalarIndexParams;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("vectorIndexParams", this.vectorIndexParams.orElse(null)).add("scalarIndexParams", this.scalarIndexParams.orElse(null)).toString();
    }

    public static class Builder {
        private Optional<VectorIndexParams> vectorIndexParams = Optional.empty();
        private Optional<ScalarIndexParams> scalarIndexParams = Optional.empty();

        private Builder() {
        }

        public Builder setVectorIndexParams(VectorIndexParams vectorIndexParams) {
            this.vectorIndexParams = Optional.of(vectorIndexParams);
            return this;
        }

        public Builder setScalarIndexParams(ScalarIndexParams scalarIndexParams) {
            this.scalarIndexParams = Optional.of(scalarIndexParams);
            return this;
        }

        public IndexParams build() {
            return new IndexParams(this);
        }
    }
}

