/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.compaction;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.JniLoader;
import com.lancedb.lance.compaction.CompactionMetrics;
import com.lancedb.lance.compaction.CompactionOptions;
import com.lancedb.lance.compaction.CompactionPlan;
import com.lancedb.lance.compaction.RewriteResult;
import com.lancedb.lance.shaded.guava.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class Compaction {
    public static CompactionPlan planCompaction(Dataset dataset, CompactionOptions compactionOptions) {
        Preconditions.checkNotNull(dataset);
        Preconditions.checkNotNull(compactionOptions);
        return Compaction.nativePlanCompaction(dataset, compactionOptions.getTargetRowsPerFragment(), compactionOptions.getMaxRowsPerGroup(), compactionOptions.getMaxBytesPerFile(), compactionOptions.getMaterializeDeletions(), compactionOptions.getMaterializeDeletionsThreshold(), compactionOptions.getNumThreads(), compactionOptions.getBatchSize(), compactionOptions.getDeferIndexRemap());
    }

    public static CompactionMetrics commitCompaction(Dataset dataset, List<RewriteResult> rewriteResults, CompactionOptions compactionOptions) {
        Preconditions.checkNotNull(dataset);
        Preconditions.checkNotNull(rewriteResults);
        Preconditions.checkNotNull(compactionOptions);
        return Compaction.nativeCommitCompaction(dataset, rewriteResults, compactionOptions.getTargetRowsPerFragment(), compactionOptions.getMaxRowsPerGroup(), compactionOptions.getMaxBytesPerFile(), compactionOptions.getMaterializeDeletions(), compactionOptions.getMaterializeDeletionsThreshold(), compactionOptions.getNumThreads(), compactionOptions.getBatchSize(), compactionOptions.getDeferIndexRemap());
    }

    public static native CompactionMetrics nativeCommitCompaction(Dataset var0, List<RewriteResult> var1, Optional<Long> var2, Optional<Long> var3, Optional<Long> var4, Optional<Boolean> var5, Optional<Float> var6, Optional<Long> var7, Optional<Long> var8, Optional<Boolean> var9);

    private static native CompactionPlan nativePlanCompaction(Dataset var0, Optional<Long> var1, Optional<Long> var2, Optional<Long> var3, Optional<Boolean> var4, Optional<Float> var5, Optional<Long> var6, Optional<Long> var7, Optional<Boolean> var8);

    static {
        JniLoader.ensureLoaded();
    }
}

