/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Arrays;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.TableCommand;
import org.apache.gravitino.rel.indexes.Index;

public class ListIndexes
extends TableCommand {
    protected final String schema;
    protected final String table;

    public ListIndexes(CommandContext context, String metalake, String catalog, String schema, String table) {
        super(context, metalake, catalog);
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void handle() {
        Index[] indexes = new Index[]{};
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            indexes = this.tableCatalog().loadTable(name).index();
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        StringBuilder all = new StringBuilder();
        for (Index index : indexes) {
            Arrays.stream(index.fieldNames()).map(nestedFieldName -> String.join((CharSequence)".", nestedFieldName)).forEach(fieldName -> all.append((String)fieldName).append(",").append(index.name()).append(System.lineSeparator()));
        }
        this.printResults(all.toString());
    }
}

