/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Arrays;
import org.apache.gravitino.Audit;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;

public class ListFilesets
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;

    public ListFilesets(CommandContext context, String metalake, String catalog, String schema) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public void handle() {
        Namespace name = Namespace.of(this.schema);
        NameIdentifier[] filesets = new NameIdentifier[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            filesets = client.loadCatalog(this.catalog).asFilesetCatalog().listFilesets(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (filesets.length == 0) {
            this.printInformation("No filesets exist.");
        } else {
            Fileset[] filesetObjects = (Fileset[])Arrays.stream(filesets).map(ident -> this.getFileset(ident.name())).toArray(Fileset[]::new);
            this.printResults(filesetObjects);
        }
    }

    private Fileset getFileset(final String name) {
        return new Fileset(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public Fileset.Type type() {
                return null;
            }

            @Override
            public Audit auditInfo() {
                return null;
            }
        };
    }
}

