/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;

final class LocalLocation
implements Location {
    private final File file;
    private final LocalLocationFactory locationFactory;

    LocalLocation(LocalLocationFactory locationFactory, File file) {
        this.file = file;
        this.locationFactory = locationFactory;
    }

    @Override
    public boolean exists() throws IOException {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        File parent = this.file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        File parent = this.file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return new FileOutputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream(String permission) throws IOException {
        return this.getOutputStream();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean createNew() throws IOException {
        return this.file.createNewFile();
    }

    @Override
    public Location append(String child) throws IOException {
        return new LocalLocation(this.locationFactory, new File(this.file, child));
    }

    @Override
    public Location getTempFile(String suffix) throws IOException {
        String newName = this.file.getAbsolutePath() + "." + UUID.randomUUID() + (suffix == null ? ".tmp" : suffix);
        return new LocalLocation(this.locationFactory, new File(newName));
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }

    @Override
    public boolean delete() throws IOException {
        return this.file.delete();
    }

    @Override
    public boolean delete(boolean recursive) throws IOException {
        if (!recursive) {
            return this.delete();
        }
        LinkedList<File> stack = new LinkedList<File>();
        stack.add(this.file);
        while (!stack.isEmpty()) {
            File f = (File)stack.peekLast();
            File[] files = f.listFiles();
            if (files != null && files.length != 0) {
                Collections.addAll(stack, files);
                continue;
            }
            if (!f.delete()) {
                return false;
            }
            stack.pollLast();
        }
        return true;
    }

    @Override
    public Location renameTo(Location destination) throws IOException {
        boolean success = this.file.renameTo(((LocalLocation)destination).file);
        if (success) {
            return new LocalLocation(this.locationFactory, ((LocalLocation)destination).file);
        }
        return null;
    }

    @Override
    public boolean mkdirs() throws IOException {
        return this.file.mkdirs();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.file.isDirectory();
    }

    @Override
    public List<Location> list() throws IOException {
        File[] files = this.file.listFiles();
        ArrayList<LocalLocation> result = new ArrayList<LocalLocation>();
        if (files != null) {
            for (File file : files) {
                result.add(new LocalLocation(this.locationFactory, file));
            }
        } else if (!this.file.exists()) {
            throw new FileNotFoundException("File " + this.file + " does not exist.");
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public LocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalLocation that = (LocalLocation)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }
}

