/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagChange;
import org.apache.gravitino.tag.TagDispatcher;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class TagHookDispatcher
implements TagDispatcher {
    private final TagDispatcher dispatcher;

    public TagHookDispatcher(TagDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public String[] listTags(String metalake) {
        return this.dispatcher.listTags(metalake);
    }

    @Override
    public Tag[] listTagsInfo(String metalake) {
        return this.dispatcher.listTagsInfo(metalake);
    }

    @Override
    public Tag getTag(String metalake, String name) throws NoSuchTagException {
        return this.dispatcher.getTag(metalake, name);
    }

    @Override
    public Tag createTag(String metalake, String name, String comment, Map<String, String> properties) {
        Tag tag = this.dispatcher.createTag(metalake, name, comment, properties);
        OwnerDispatcher ownerDispatcher = GravitinoEnv.getInstance().ownerDispatcher();
        if (ownerDispatcher != null) {
            ownerDispatcher.setOwner(metalake, NameIdentifierUtil.toMetadataObject(NameIdentifierUtil.ofTag(metalake, name), Entity.EntityType.TAG), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return tag;
    }

    @Override
    public Tag alterTag(String metalake, String name, TagChange ... changes) {
        return this.dispatcher.alterTag(metalake, name, changes);
    }

    @Override
    public boolean deleteTag(String metalake, String name) {
        return this.dispatcher.deleteTag(metalake, name);
    }

    @Override
    public MetadataObject[] listMetadataObjectsForTag(String metalake, String name) {
        return this.dispatcher.listMetadataObjectsForTag(metalake, name);
    }

    @Override
    public String[] listTagsForMetadataObject(String metalake, MetadataObject metadataObject) {
        return this.dispatcher.listTagsForMetadataObject(metalake, metadataObject);
    }

    @Override
    public Tag[] listTagsInfoForMetadataObject(String metalake, MetadataObject metadataObject) {
        return this.dispatcher.listTagsInfoForMetadataObject(metalake, metadataObject);
    }

    @Override
    public String[] associateTagsForMetadataObject(String metalake, MetadataObject metadataObject, String[] tagsToAdd, String[] tagsToRemove) {
        return this.dispatcher.associateTagsForMetadataObject(metalake, metadataObject, tagsToAdd, tagsToRemove);
    }

    @Override
    public Tag getTagForMetadataObject(String metalake, MetadataObject metadataObject, String name) {
        return this.dispatcher.getTagForMetadataObject(metalake, metadataObject, name);
    }
}

