/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.backend.hms;

import org.apache.gravitino.catalog.lakehouse.hudi.HudiColumn;
import org.apache.gravitino.catalog.lakehouse.hudi.HudiTable;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

public class HudiHMSTable
extends HudiTable<Table> {
    public static Builder builder() {
        return new Builder();
    }

    private HudiHMSTable() {
    }

    @Override
    public Table fromHudiTable() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    static /* synthetic */ Column[] access$202(HudiHMSTable x0, Column[] x1) {
        x0.columns = x1;
        return x1;
    }

    static /* synthetic */ Index[] access$302(HudiHMSTable x0, Index[] x1) {
        x0.indexes = x1;
        return x1;
    }

    static /* synthetic */ Transform[] access$402(HudiHMSTable x0, Transform[] x1) {
        x0.partitioning = x1;
        return x1;
    }

    static /* synthetic */ SortOrder[] access$502(HudiHMSTable x0, SortOrder[] x1) {
        x0.sortOrders = x1;
        return x1;
    }

    public static class Builder
    extends HudiTable.Builder<Table> {
        protected HudiHMSTable simpleBuild() {
            HudiHMSTable table = new HudiHMSTable();
            table.name = this.name;
            table.comment = this.comment;
            HudiHMSTable.access$202(table, this.columns);
            HudiHMSTable.access$302(table, this.indexes);
            HudiHMSTable.access$402(table, this.partitioning);
            HudiHMSTable.access$502(table, this.sortOrders);
            table.distribution = this.distribution;
            table.properties = this.properties;
            table.auditInfo = this.auditInfo;
            return table;
        }

        protected HudiHMSTable buildFromTable(Table hmsTable) {
            this.name = hmsTable.name();
            this.comment = hmsTable.comment();
            Column[] backendColumns = hmsTable.columns();
            HudiColumn[] hudiColumns = new HudiColumn[backendColumns.length];
            for (int i = 0; i < backendColumns.length; ++i) {
                Column c = backendColumns[i];
                hudiColumns[i] = (HudiColumn)((HudiColumn.Builder)((HudiColumn.Builder)((HudiColumn.Builder)((HudiColumn.Builder)((HudiColumn.Builder)((HudiColumn.Builder)HudiColumn.builder().withName(c.name())).withComment(c.comment())).withType(c.dataType())).withNullable(c.nullable())).withAutoIncrement(c.autoIncrement())).withDefaultValue(c.defaultValue())).build();
            }
            this.columns = hudiColumns;
            this.partitioning = hmsTable.partitioning();
            this.sortOrders = hmsTable.sortOrder();
            this.distribution = hmsTable.distribution();
            this.auditInfo = AuditInfo.builder().withCreator(hmsTable.auditInfo().creator()).build();
            this.properties = hmsTable.properties();
            return this.simpleBuild();
        }
    }
}

