/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.HudiCatalogBackend;
import org.apache.gravitino.catalog.lakehouse.hudi.ops.HudiCatalogBackendOps;
import org.apache.gravitino.catalog.lakehouse.hudi.utils.CatalogUtils;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudiCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TableCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(HudiCatalogOperations.class);
    @VisibleForTesting
    HudiCatalogBackendOps hudiCatalogBackendOps;

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        HudiCatalogBackend hudiCatalogBackend = CatalogUtils.loadHudiCatalogBackend((Map<String, String>)ImmutableMap.builder().putAll(config).put((Object)"catalogId", (Object)(Objects.nonNull(info) ? String.valueOf(info.id()) : "0")).build());
        this.hudiCatalogBackendOps = hudiCatalogBackend.backendOps();
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        try {
            this.hudiCatalogBackendOps.listSchemas(Namespace.of((String[])new String[]{catalogIdent.namespace().level(0), catalogIdent.name()}));
        }
        catch (Exception e) {
            throw new ConnectionFailedException((Throwable)e, "Failed to run listSchemas on Hudi catalog: %s", new Object[]{e.getMessage()});
        }
    }

    public void close() {
        if (this.hudiCatalogBackendOps != null) {
            try {
                this.hudiCatalogBackendOps.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close Hudi catalog", (Throwable)e);
            }
        }
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        return this.hudiCatalogBackendOps.listSchemas(namespace);
    }

    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        return this.hudiCatalogBackendOps.createSchema(ident, comment, properties);
    }

    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        return this.hudiCatalogBackendOps.loadSchema(ident);
    }

    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        return this.hudiCatalogBackendOps.alterSchema(ident, changes);
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        return this.hudiCatalogBackendOps.dropSchema(ident, cascade);
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        return this.hudiCatalogBackendOps.listTables(namespace);
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        return this.hudiCatalogBackendOps.loadTable(ident);
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        return this.hudiCatalogBackendOps.createTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes);
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        return this.hudiCatalogBackendOps.alterTable(ident, changes);
    }

    public boolean dropTable(NameIdentifier ident) {
        return this.hudiCatalogBackendOps.dropTable(ident);
    }
}

