/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.shade.org.roaringbitmap.RoaringBitmap;

public class RoaringBitmap32 {
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    private final RoaringBitmap roaringBitmap;

    public RoaringBitmap32() {
        this.roaringBitmap = new RoaringBitmap();
    }

    private RoaringBitmap32(RoaringBitmap roaringBitmap) {
        this.roaringBitmap = roaringBitmap;
    }

    protected RoaringBitmap get() {
        return this.roaringBitmap;
    }

    public void add(int x) {
        this.roaringBitmap.add(x);
    }

    public void or(RoaringBitmap32 other) {
        this.roaringBitmap.or(other.roaringBitmap);
    }

    public boolean checkedAdd(int x) {
        return this.roaringBitmap.checkedAdd(x);
    }

    public boolean contains(int x) {
        return this.roaringBitmap.contains(x);
    }

    public boolean isEmpty() {
        return this.roaringBitmap.isEmpty();
    }

    public long getCardinality() {
        return this.roaringBitmap.getLongCardinality();
    }

    public int first() {
        return this.roaringBitmap.first();
    }

    public int last() {
        return this.roaringBitmap.last();
    }

    public long nextValue(int fromValue) {
        return this.roaringBitmap.nextValue(fromValue);
    }

    public long previousValue(int fromValue) {
        return this.roaringBitmap.previousValue(fromValue);
    }

    public boolean intersects(long minimum, long supremum) {
        return this.roaringBitmap.intersects(minimum, supremum);
    }

    public RoaringBitmap32 clone() {
        return new RoaringBitmap32(this.roaringBitmap.clone());
    }

    public void serialize(DataOutput out) throws IOException {
        this.roaringBitmap.runOptimize();
        this.roaringBitmap.serialize(out);
    }

    public byte[] serialize() {
        this.roaringBitmap.runOptimize();
        ByteBuffer buffer = ByteBuffer.allocate(this.roaringBitmap.serializedSizeInBytes());
        this.roaringBitmap.serialize(buffer);
        return buffer.array();
    }

    public void deserialize(DataInput in) throws IOException {
        this.roaringBitmap.deserialize(in, null);
    }

    public void deserialize(ByteBuffer buffer) throws IOException {
        this.roaringBitmap.deserialize(buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoaringBitmap32 that = (RoaringBitmap32)o;
        return Objects.equals(this.roaringBitmap, that.roaringBitmap);
    }

    public void clear() {
        this.roaringBitmap.clear();
    }

    public void flip(long rangeStart, long rangeEnd) {
        this.roaringBitmap.flip(rangeStart, rangeEnd);
    }

    public Iterator<Integer> iterator() {
        return this.roaringBitmap.iterator();
    }

    public String toString() {
        return this.roaringBitmap.toString();
    }

    @VisibleForTesting
    public static RoaringBitmap32 bitmapOf(int ... dat) {
        RoaringBitmap32 roaringBitmap32 = new RoaringBitmap32();
        for (int ele : dat) {
            roaringBitmap32.add(ele);
        }
        return roaringBitmap32;
    }

    public static RoaringBitmap32 and(RoaringBitmap32 x1, RoaringBitmap32 x2) {
        return new RoaringBitmap32(RoaringBitmap.and(x1.roaringBitmap, x2.roaringBitmap));
    }

    public static RoaringBitmap32 or(RoaringBitmap32 x1, RoaringBitmap32 x2) {
        return new RoaringBitmap32(RoaringBitmap.or(x1.roaringBitmap, x2.roaringBitmap));
    }

    public static RoaringBitmap32 or(final Iterator<RoaringBitmap32> iterator) {
        return new RoaringBitmap32(RoaringBitmap.or((Iterator<? extends RoaringBitmap>)new Iterator<RoaringBitmap>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public RoaringBitmap next() {
                return ((RoaringBitmap32)iterator.next()).roaringBitmap;
            }
        }));
    }

    public static RoaringBitmap32 andNot(RoaringBitmap32 x1, RoaringBitmap32 x2) {
        return new RoaringBitmap32(RoaringBitmap.andNot(x1.roaringBitmap, x2.roaringBitmap));
    }
}

