/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.paimon.shade.org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectNonNativeWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.StepBoolean;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.Util;

final class DirectNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private static final int id = 40;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private final MemoryRequestServer memReqSvr;
    private final byte typeId;

    DirectNonNativeWritableMemoryImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid, MemoryRequestServer memReqSvr) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.memReqSvr = memReqSvr;
        this.typeId = (byte)(0x28 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = DirectNonNativeWritableMemoryImpl.setReadOnlyType(this.typeId, readOnly) | 2;
        return Util.isNativeByteOrder(byteOrder) ? new DirectWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr) : new DirectNonNativeWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        byte type = DirectNonNativeWritableMemoryImpl.setReadOnlyType(this.typeId, readOnly);
        return Util.isNativeByteOrder(byteOrder) ? new DirectWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr) : new DirectNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr);
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        this.assertValid();
        return this.memReqSvr;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

