/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySlice;

public class MemorySliceOutput {
    private MemorySegment segment;
    private int size;

    public MemorySliceOutput(int estimatedSize) {
        this.segment = MemorySegment.wrap(new byte[estimatedSize]);
    }

    public int size() {
        return this.size;
    }

    public MemorySlice toSlice() {
        return new MemorySlice(this.segment, 0, this.size);
    }

    public void reset() {
        this.size = 0;
    }

    public void writeByte(int value) {
        this.ensureSize(this.size + 1);
        this.segment.put(this.size++, (byte)value);
    }

    public void writeInt(int value) {
        this.ensureSize(this.size + 4);
        this.segment.putInt(this.size, value);
        this.size += 4;
    }

    public void writeVarLenInt(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        while ((value & 0xFFFFFF80) != 0) {
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeLong(long value) {
        this.ensureSize(this.size + 8);
        this.segment.putLong(this.size, value);
        this.size += 8;
    }

    public void writeVarLenLong(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    public void writeBytes(byte[] source, int sourceIndex, int length) {
        this.ensureSize(this.size + length);
        this.segment.put(this.size, source, sourceIndex, length);
        this.size += length;
    }

    private void ensureSize(int minWritableBytes) {
        int newCapacity;
        if (minWritableBytes <= this.segment.size()) {
            return;
        }
        int minNewCapacity = this.segment.size() + minWritableBytes;
        for (newCapacity = this.segment.size(); newCapacity < minNewCapacity; newCapacity <<= 1) {
        }
        MemorySegment newSegment = MemorySegment.wrap(new byte[newCapacity]);
        this.segment.copyTo(0, newSegment, 0, this.segment.size());
        this.segment = newSegment;
    }
}

