/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.paimon.io.PageFileInput;
import org.apache.paimon.utils.MathUtils;

public class UncompressedPageFileInput
implements PageFileInput {
    private final RandomAccessFile file;
    private final long fileLength;
    private final int pageSize;
    private final int pageSizeBits;

    public UncompressedPageFileInput(RandomAccessFile file, int pageSize) throws IOException {
        this.file = file;
        this.fileLength = file.length();
        this.pageSize = pageSize;
        this.pageSizeBits = MathUtils.log2strict((int)pageSize);
    }

    @Override
    public RandomAccessFile file() {
        return this.file;
    }

    @Override
    public long uncompressBytes() {
        return this.fileLength;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public byte[] readPage(int pageIndex) throws IOException {
        long position = (long)pageIndex << this.pageSizeBits;
        this.file.seek(position);
        int length = (int)Math.min((long)this.pageSize, this.fileLength - position);
        byte[] result = new byte[length];
        this.file.readFully(result);
        return result;
    }

    @Override
    public byte[] readPosition(long position, int length) throws IOException {
        this.file.seek(position);
        byte[] result = new byte[length];
        this.file.readFully(result);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

