/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.utils.Preconditions;

@Public
public final class Timestamp
implements Comparable<Timestamp>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MICROS_PER_MILLIS = 1000L;
    public static final long NANOS_PER_MICROS = 1000L;
    private final long millisecond;
    private final int nanoOfMillisecond;

    private Timestamp(long millisecond, int nanoOfMillisecond) {
        Preconditions.checkArgument((nanoOfMillisecond >= 0 && nanoOfMillisecond <= 999999 ? 1 : 0) != 0);
        this.millisecond = millisecond;
        this.nanoOfMillisecond = nanoOfMillisecond;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public int getNanoOfMillisecond() {
        return this.nanoOfMillisecond;
    }

    public java.sql.Timestamp toSQLTimestamp() {
        return java.sql.Timestamp.valueOf(this.toLocalDateTime());
    }

    public Timestamp toMillisTimestamp() {
        return Timestamp.fromEpochMillis(this.millisecond);
    }

    public LocalDateTime toLocalDateTime() {
        int date = (int)(this.millisecond / 86400000L);
        int time = (int)(this.millisecond % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        long nanoOfDay = (long)time * 1000000L + (long)this.nanoOfMillisecond;
        LocalDate localDate = LocalDate.ofEpochDay(date);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    @Deprecated
    public Instant toInstant() {
        long epochSecond = this.millisecond / 1000L;
        int milliOfSecond = (int)(this.millisecond % 1000L);
        if (milliOfSecond < 0) {
            --epochSecond;
            milliOfSecond += 1000;
        }
        long nanoAdjustment = milliOfSecond * 1000000 + this.nanoOfMillisecond;
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
    }

    public long toMicros() {
        long micros = Math.multiplyExact(this.millisecond, 1000L);
        return micros + (long)this.nanoOfMillisecond / 1000L;
    }

    @Override
    public int compareTo(Timestamp that) {
        int cmp = Long.compare(this.millisecond, that.millisecond);
        if (cmp == 0) {
            cmp = this.nanoOfMillisecond - that.nanoOfMillisecond;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Timestamp)) {
            return false;
        }
        Timestamp that = (Timestamp)obj;
        return this.millisecond == that.millisecond && this.nanoOfMillisecond == that.nanoOfMillisecond;
    }

    public String toString() {
        return this.toLocalDateTime().toString();
    }

    public int hashCode() {
        int ret = (int)this.millisecond ^ (int)(this.millisecond >> 32);
        return 31 * ret + this.nanoOfMillisecond;
    }

    public static Timestamp now() {
        return Timestamp.fromLocalDateTime(LocalDateTime.now());
    }

    public static Timestamp fromEpochMillis(long milliseconds) {
        return new Timestamp(milliseconds, 0);
    }

    public static Timestamp fromEpochMillis(long milliseconds, int nanosOfMillisecond) {
        return new Timestamp(milliseconds, nanosOfMillisecond);
    }

    public static Timestamp fromLocalDateTime(LocalDateTime dateTime) {
        long epochDay = dateTime.toLocalDate().toEpochDay();
        long nanoOfDay = dateTime.toLocalTime().toNanoOfDay();
        long millisecond = epochDay * 86400000L + nanoOfDay / 1000000L;
        int nanoOfMillisecond = (int)(nanoOfDay % 1000000L);
        return new Timestamp(millisecond, nanoOfMillisecond);
    }

    public static Timestamp fromSQLTimestamp(java.sql.Timestamp timestamp) {
        return Timestamp.fromLocalDateTime(timestamp.toLocalDateTime());
    }

    @Deprecated
    public static Timestamp fromInstant(Instant instant) {
        long epochSecond = instant.getEpochSecond();
        int nanoSecond = instant.getNano();
        long millisecond = epochSecond * 1000L + (long)(nanoSecond / 1000000);
        int nanoOfMillisecond = nanoSecond % 1000000;
        return new Timestamp(millisecond, nanoOfMillisecond);
    }

    public static Timestamp fromMicros(long micros) {
        long mills = Math.floorDiv(micros, 1000L);
        long nanos = (micros - mills * 1000L) * 1000L;
        return Timestamp.fromEpochMillis(mills, (int)nanos);
    }

    public static boolean isCompact(int precision) {
        return precision <= 3;
    }
}

