/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.dto.requests.ModelRegisterRequest;
import org.apache.gravitino.dto.requests.ModelUpdateRequest;
import org.apache.gravitino.dto.requests.ModelUpdatesRequest;
import org.apache.gravitino.dto.requests.ModelVersionLinkRequest;
import org.apache.gravitino.dto.requests.ModelVersionUpdateRequest;
import org.apache.gravitino.dto.requests.ModelVersionUpdatesRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.ModelResponse;
import org.apache.gravitino.dto.responses.ModelVersionInfoListResponse;
import org.apache.gravitino.dto.responses.ModelVersionListResponse;
import org.apache.gravitino.dto.responses.ModelVersionResponse;
import org.apache.gravitino.dto.responses.ModelVersionUriResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metalakes/{metalake}/catalogs/{catalog}/schemas/{schema}/models")
public class ModelOperations {
    private static final Logger LOG = LoggerFactory.getLogger(ModelOperations.class);
    private final ModelDispatcher modelDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public ModelOperations(ModelDispatcher modelDispatcher) {
        this.modelDispatcher = modelDispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-model", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nANY_USE_CATALOG && (SCHEMA::OWNER || ANY_USE_SCHEMA)\n", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response listModels(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema) {
        LOG.info("Received list models request for schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
        Namespace modelNs = NamespaceUtil.ofModel((String)metalake, (String)catalog, (String)schema);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                NameIdentifier[] modelIds = this.modelDispatcher.listModels(modelNs);
                modelIds = modelIds == null ? new NameIdentifier[]{} : modelIds;
                modelIds = MetadataAuthzHelper.filterByExpression((String)metalake, (String)"ANY(OWNER, METALAKE, CATALOG, SCHEMA, MODEL) || ANY_USE_MODEL", (Entity.EntityType)Entity.EntityType.MODEL, (NameIdentifier[])modelIds);
                LOG.info("List {} models under schema {}", (Object)modelIds.length, (Object)modelNs);
                return Utils.ok((Object)new EntityListResponse(modelIds));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.LIST, "", schema, e);
        }
    }

    @GET
    @Path(value="{model}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response getModel(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model) {
        LOG.info("Received get model request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Model m = this.modelDispatcher.getModel(modelId);
                LOG.info("Model got: {}", (Object)modelId);
                return Utils.ok((Object)new ModelResponse(DTOConverters.toDTO((Model)m)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, model, schema, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="register-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="register-model", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && ANY_REGISTER_MODEL\n", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response registerModel(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, ModelRegisterRequest request) {
        LOG.info("Received register model request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, request.getName()});
        try {
            request.validate();
            NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)request.getName());
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Model m = this.modelDispatcher.registerModel(modelId, request.getComment(), request.getProperties());
                LOG.info("Model registered: {}", (Object)modelId);
                return Utils.ok((Object)new ModelResponse(DTOConverters.toDTO((Model)m)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.REGISTER, request.getName(), schema, e);
        }
    }

    @DELETE
    @Path(value="{model}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-model", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && MODEL::OWNER\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response deleteModel(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model) {
        LOG.info("Received delete model request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean deleted = this.modelDispatcher.deleteModel(modelId);
                if (!deleted) {
                    LOG.warn("Cannot find to be deleted model {} under schema {}", (Object)model, (Object)schema);
                } else {
                    LOG.info("Model deleted: {}", (Object)modelId);
                }
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(deleted)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.DELETE, model, schema, e);
        }
    }

    @GET
    @Path(value="{model}/versions")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-model-versions.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-model-versions", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response listModelVersions(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list model versions request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                if (verbose) {
                    ModelVersion[] modelVersions = this.modelDispatcher.listModelVersionInfos(modelId);
                    modelVersions = modelVersions == null ? new ModelVersion[]{} : modelVersions;
                    modelVersions = (ModelVersion[])Arrays.stream(modelVersions).filter(modelVersion -> {
                        NameIdentifier[] nameIdentifiers = new NameIdentifier[]{NameIdentifierUtil.ofModelVersion((String)metalake, (String)catalog, (String)schema, (String)model, (int)modelVersion.version())};
                        return MetadataAuthzHelper.filterByExpression((String)metalake, (String)"ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", (Entity.EntityType)Entity.EntityType.MODEL_VERSION, (NameIdentifier[])nameIdentifiers).length > 0;
                    }).toArray(ModelVersion[]::new);
                    LOG.info("List {} versions of model {}", (Object)modelVersions.length, (Object)modelId);
                    return Utils.ok((Object)new ModelVersionInfoListResponse(DTOConverters.toDTOs((ModelVersion[])modelVersions)));
                }
                int[] versions = this.modelDispatcher.listModelVersions(modelId);
                versions = versions == null ? new int[]{} : versions;
                versions = Arrays.stream(versions).filter(modelVersion -> {
                    NameIdentifier[] nameIdentifiers = new NameIdentifier[]{NameIdentifierUtil.ofModelVersion((String)metalake, (String)catalog, (String)schema, (String)model, (int)modelVersion)};
                    return MetadataAuthzHelper.filterByExpression((String)metalake, (String)"ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", (Entity.EntityType)Entity.EntityType.MODEL_VERSION, (NameIdentifier[])nameIdentifiers).length > 0;
                }).toArray();
                LOG.info("List {} versions of model {}", (Object)versions.length, (Object)modelId);
                return Utils.ok((Object)new ModelVersionListResponse(versions));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.LIST_VERSIONS, model, schema, e);
        }
    }

    @GET
    @Path(value="{model}/versions/{version}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model-version.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model-version", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response getModelVersion(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="version") int version) {
        LOG.info("Received get model version request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, version});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                ModelVersion mv = this.modelDispatcher.getModelVersion(modelId, version);
                LOG.info("Model version got: {}.{}", (Object)modelId, (Object)version);
                return Utils.ok((Object)new ModelVersionResponse(DTOConverters.toDTO((ModelVersion)mv)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, this.versionString(model, version), schema, e);
        }
    }

    @GET
    @Path(value="{model}/aliases/{alias}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model-alias.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model-alias", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response getModelVersionByAlias(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="alias") String alias) {
        LOG.info("Received get model version alias request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, alias});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                ModelVersion mv = this.modelDispatcher.getModelVersion(modelId, alias);
                LOG.info("Model version alias got: {}.{}", (Object)modelId, (Object)alias);
                return Utils.ok((Object)new ModelVersionResponse(DTOConverters.toDTO((ModelVersion)mv)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, this.aliasString(model, alias), schema, e);
        }
    }

    @POST
    @Path(value="{model}/versions")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="link-model-version.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="link-model-version", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL && ANY_LINK_MODEL_VERSION)\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response linkModelVersion(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, ModelVersionLinkRequest request) {
        LOG.info("Received link model version request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            request.validate();
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Map tmpUris = Optional.ofNullable(request.getUris()).orElse(Collections.emptyMap());
                ImmutableMap.Builder uris = ImmutableMap.builder().putAll(tmpUris);
                Optional.ofNullable(request.getUri()).ifPresent(uri -> uris.put((Object)"unknown", uri));
                this.modelDispatcher.linkModelVersion(modelId, (Map)uris.buildKeepingLast(), request.getAliases(), request.getComment(), request.getProperties());
                LOG.info("Model version linked: {}", (Object)modelId);
                return Utils.ok((Object)new BaseResponse());
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.LINK, model, schema, e);
        }
    }

    @DELETE
    @Path(value="{model}/versions/{version}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-model-version.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-model-version", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && MODEL::OWNER\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response deleteModelVersion(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="version") int version) {
        LOG.info("Received delete model version request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, version});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean deleted = this.modelDispatcher.deleteModelVersion(modelId, version);
                if (!deleted) {
                    LOG.warn("Cannot find to be deleted version {} in model {}", (Object)version, (Object)model);
                } else {
                    LOG.info("Model version deleted: {}.{}", (Object)modelId, (Object)version);
                }
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(deleted)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.DELETE, this.versionString(model, version), schema, e);
        }
    }

    @DELETE
    @Path(value="{model}/aliases/{alias}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-model-alias.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-model-alias", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && MODEL::OWNER\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response deleteModelVersionByAlias(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="alias") String alias) {
        LOG.info("Received delete model version by alias request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, alias});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean deleted = this.modelDispatcher.deleteModelVersion(modelId, alias);
                if (!deleted) {
                    LOG.warn("Cannot find to be deleted model version by alias {} in model {}", (Object)alias, (Object)model);
                } else {
                    LOG.info("Model version by alias deleted: {}.{}", (Object)modelId, (Object)alias);
                }
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(deleted)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.DELETE, this.aliasString(model, alias), schema, e);
        }
    }

    @PUT
    @Path(value="{model}/versions/{version}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-model-version.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-model-version", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && MODEL::OWNER\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response alterModelVersion(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="version") int version, ModelVersionUpdatesRequest request) {
        LOG.info("Received alter model version request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, version});
        request.validate();
        try {
            NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                ModelVersionChange[] changes = (ModelVersionChange[])request.getUpdates().stream().map(ModelVersionUpdateRequest::modelVersionChange).toArray(ModelVersionChange[]::new);
                ModelVersion modelVersion = this.modelDispatcher.alterModelVersion(modelId, version, changes);
                Response response = Utils.ok((Object)new ModelVersionResponse(DTOConverters.toDTO((ModelVersion)modelVersion)));
                LOG.info("Model version altered: {}.{}", (Object)modelId, (Object)version);
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.ALTER, this.versionString(model, version), schema, e);
        }
    }

    @PUT
    @Path(value="{model}/aliases/{alias}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-model-alias.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-model-alias", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && MODEL::OWNER\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response alterModelVersionByAlias(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="alias") String alias, ModelVersionUpdatesRequest request) {
        LOG.info("Received alter model version request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, alias});
        request.validate();
        try {
            NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                ModelVersionChange[] changes = (ModelVersionChange[])request.getUpdates().stream().map(ModelVersionUpdateRequest::modelVersionChange).toArray(ModelVersionChange[]::new);
                ModelVersion modelVersion = this.modelDispatcher.alterModelVersion(modelId, alias, changes);
                Response response = Utils.ok((Object)new ModelVersionResponse(DTOConverters.toDTO((ModelVersion)modelVersion)));
                LOG.info("Model version altered: {}.{}", (Object)modelId, (Object)alias);
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.ALTER, this.aliasString(model, alias), schema, e);
        }
    }

    @PUT
    @Path(value="{model}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-model", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && MODEL::OWNER\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response alterModel(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, ModelUpdatesRequest request) {
        LOG.info("Received alter model request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
                ModelChange[] changes = (ModelChange[])request.getUpdates().stream().map(ModelUpdateRequest::modelChange).toArray(ModelChange[]::new);
                Model m = this.modelDispatcher.alterModel(ident, changes);
                Response response = Utils.ok((Object)new ModelResponse(DTOConverters.toDTO((Model)m)));
                LOG.info("Model altered: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, m.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.ALTER, model, schema, e);
        }
    }

    @GET
    @Path(value="{model}/versions/{version}/uri")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model-version-uri.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model-version-uri", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response getModelVersionUri(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="version") int version, @QueryParam(value="uriName") String uriName) {
        LOG.info("Received get model version uri request: {}.{}.{}.{}.{}, uriName: {}", new Object[]{metalake, catalog, schema, model, version, uriName});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                String uri = this.modelDispatcher.getModelVersionUri(modelId, version, uriName);
                return Utils.ok((Object)new ModelVersionUriResponse(uri));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, this.versionString(model, version), schema, e);
        }
    }

    @GET
    @Path(value="{model}/aliases/{alias}/uri")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model-alias-uri.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model-alias-uri", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", accessMetadataType=MetadataObject.Type.MODEL)
    public Response getModelVersionUriByAlias(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="model") @AuthorizationMetadata(type=Entity.EntityType.MODEL) String model, @PathParam(value="alias") String alias, @QueryParam(value="uriName") String uriName) {
        LOG.info("Received get model version alias uri request: {}.{}.{}.{}.{}, uriName: {}", new Object[]{metalake, catalog, schema, model, alias, uriName});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                String uri = this.modelDispatcher.getModelVersionUri(modelId, alias, uriName);
                return Utils.ok((Object)new ModelVersionUriResponse(uri));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, this.aliasString(model, alias), schema, e);
        }
    }

    private String versionString(String model, int version) {
        return model + " version(" + version + ")";
    }

    private String aliasString(String model, String alias) {
        return model + " alias(" + alias + ")";
    }
}

