/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.jdbc.JdbcCatalogPropertiesMetadata;
import org.apache.gravitino.catalog.jdbc.JdbcColumn;
import org.apache.gravitino.catalog.jdbc.JdbcSchema;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.JdbcTablePropertiesMetadata;
import org.apache.gravitino.catalog.jdbc.config.JdbcConfig;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.DatabaseOperation;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.catalog.jdbc.operation.RequireDatabaseOperation;
import org.apache.gravitino.catalog.jdbc.operation.TableOperation;
import org.apache.gravitino.catalog.jdbc.utils.DataSourceUtils;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.JdbcCatalogMetricsSource;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.utils.IsolatedClassLoader;
import org.apache.gravitino.utils.MapUtils;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TableCatalog {
    private static final String GRAVITINO_ATTRIBUTE_DOES_NOT_EXIST_MSG = "The Gravitino id attribute does not exist in properties";
    public static final Logger LOG = LoggerFactory.getLogger(JdbcCatalogOperations.class);
    private JdbcCatalogPropertiesMetadata jdbcCatalogPropertiesMetadata;
    private JdbcTablePropertiesMetadata jdbcTablePropertiesMetadata;
    private final JdbcExceptionConverter exceptionConverter;
    private final JdbcTypeConverter jdbcTypeConverter;
    private final DatabaseOperation databaseOperation;
    private final TableOperation tableOperation;
    private DataSource dataSource;
    private final JdbcColumnDefaultValueConverter columnDefaultValueConverter;
    private JdbcCatalogMetricsSource catalogMetricsSource;

    public JdbcCatalogOperations(JdbcExceptionConverter exceptionConverter, JdbcTypeConverter jdbcTypeConverter, JdbcDatabaseOperations databaseOperation, JdbcTableOperations tableOperation, JdbcColumnDefaultValueConverter columnDefaultValueConverter) {
        this.exceptionConverter = exceptionConverter;
        this.jdbcTypeConverter = jdbcTypeConverter;
        this.databaseOperation = databaseOperation;
        this.tableOperation = tableOperation;
        this.columnDefaultValueConverter = columnDefaultValueConverter;
    }

    public void initialize(Map<String, String> conf, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        MetricsSystem metricsSystem;
        this.jdbcCatalogPropertiesMetadata = (JdbcCatalogPropertiesMetadata)propertiesMetadata.catalogPropertiesMetadata();
        this.jdbcTablePropertiesMetadata = (JdbcTablePropertiesMetadata)propertiesMetadata.tablePropertiesMetadata();
        Map prefixMap = MapUtils.getPrefixMap(conf, (String)"gravitino.bypass.");
        Map<String, String> gravitinoConfig = this.jdbcCatalogPropertiesMetadata.transformProperties(conf);
        HashMap resultConf = Maps.newHashMap((Map)prefixMap);
        resultConf.putAll(gravitinoConfig);
        JdbcConfig jdbcConfig = new JdbcConfig(resultConf);
        this.dataSource = DataSourceUtils.createDataSource(jdbcConfig);
        this.checkJDBCDriverVersion();
        this.databaseOperation.initialize(this.dataSource, this.exceptionConverter, resultConf);
        this.tableOperation.initialize(this.dataSource, this.exceptionConverter, this.jdbcTypeConverter, this.columnDefaultValueConverter, resultConf);
        if (this.tableOperation instanceof RequireDatabaseOperation) {
            ((RequireDatabaseOperation)((Object)this.tableOperation)).setDatabaseOperation(this.databaseOperation);
        }
        if ((metricsSystem = GravitinoEnv.getInstance().metricsSystem()) != null) {
            this.catalogMetricsSource = new JdbcCatalogMetricsSource(info.namespace().toString(), info.name());
            this.catalogMetricsSource.registerDatasourceMetrics(this.dataSource);
            metricsSystem.register((MetricsSource)this.catalogMetricsSource);
        }
    }

    public void close() {
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        if (metricsSystem != null) {
            metricsSystem.unregister((MetricsSource)this.catalogMetricsSource);
        }
        DataSourceUtils.closeDataSource(this.dataSource);
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        List<String> schemaNames = this.databaseOperation.listDatabases();
        return (NameIdentifier[])schemaNames.stream().map(db -> NameIdentifier.of((Namespace)namespace, (String)db)).toArray(NameIdentifier[]::new);
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        this.databaseOperation.listDatabases();
    }

    public JdbcSchema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        StringIdentifier identifier = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((identifier != null ? 1 : 0) != 0, (Object)GRAVITINO_ATTRIBUTE_DOES_NOT_EXIST_MSG);
        String notAllowedKey = properties.keySet().stream().filter(s -> !StringUtils.equals((CharSequence)s, (CharSequence)"gravitino.identifier")).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((CharSequence)notAllowedKey)) {
            LOG.warn("The properties [{}] are not allowed to be set in the jdbc schema", (Object)notAllowedKey);
        }
        HashMap resultProperties = Maps.newHashMap(properties);
        resultProperties.remove("gravitino.identifier");
        this.databaseOperation.create(ident.name(), StringIdentifier.addToComment((StringIdentifier)identifier, (String)comment), resultProperties);
        return (JdbcSchema)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)JdbcSchema.builder().withName(ident.name())).withProperties(resultProperties)).withComment(comment)).withAuditInfo(AuditInfo.builder().withCreator(JdbcCatalogOperations.currentUser()).withCreateTime(Instant.now()).build())).build();
    }

    public JdbcSchema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        JdbcSchema load = this.databaseOperation.load(ident.name());
        String comment = load.comment();
        StringIdentifier id = StringIdentifier.fromComment((String)comment);
        if (id == null) {
            LOG.warn("The comment {} does not contain Gravitino id attribute", (Object)comment);
            return load;
        }
        HashMap properties = load.properties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)load.properties());
        return (JdbcSchema)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)JdbcSchema.builder().withAuditInfo(load.auditInfo())).withName(load.name())).withComment(StringIdentifier.removeIdFromComment((String)load.comment()))).withProperties(StringIdentifier.newPropertiesWithId((StringIdentifier)id, (Map)properties))).build();
    }

    public JdbcSchema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        throw new UnsupportedOperationException("jdbc-catalog does not support alter the schema");
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        return this.databaseOperation.delete(ident.name(), cascade);
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        String databaseName = NameIdentifier.of((String[])namespace.levels()).name();
        return (NameIdentifier[])this.tableOperation.listTables(databaseName).stream().map(table -> NameIdentifier.of((Namespace)namespace, (String)table)).toArray(NameIdentifier[]::new);
    }

    public Table loadTable(NameIdentifier tableIdent) throws NoSuchTableException {
        String tableName;
        String databaseName = NameIdentifier.of((String[])tableIdent.namespace().levels()).name();
        JdbcTable load = this.tableOperation.load(databaseName, tableName = tableIdent.name());
        Map properties = load.properties() == null ? Maps.newHashMap() : this.jdbcTablePropertiesMetadata.convertFromJdbcProperties(load.properties());
        String comment = load.comment();
        StringIdentifier id = StringIdentifier.fromComment((String)comment);
        if (id == null) {
            LOG.warn("The table {} comment {} does not contain Gravitino id attribute", (Object)tableName, (Object)comment);
        } else {
            properties = StringIdentifier.newPropertiesWithId((StringIdentifier)id, (Map)properties);
            comment = StringIdentifier.removeIdFromComment((String)comment);
        }
        return ((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)JdbcTable.builder().withAuditInfo(load.auditInfo())).withName(tableName)).withColumns(load.columns())).withAuditInfo(load.auditInfo())).withComment(comment)).withProperties(properties)).withDistribution(load.distribution())).withIndexes(load.index())).withPartitioning(load.partitioning())).withDatabaseName(databaseName).withTableOperation(this.tableOperation).build();
    }

    public Table alterTable(NameIdentifier tableIdent, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        Optional<TableChange> renameTableOptional = Arrays.stream(changes).filter(tableChange -> tableChange instanceof TableChange.RenameTable).reduce((a, b) -> b);
        if (renameTableOptional.isPresent()) {
            String otherChange = Arrays.stream(changes).filter(tableChange -> !(tableChange instanceof TableChange.RenameTable)).map(String::valueOf).collect(Collectors.joining("\n"));
            Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)otherChange), (Object)String.format("The operation to change the table name cannot be performed together with other operations.The list of operations that you cannot perform includes: \n %s", otherChange));
            return this.renameTable(tableIdent, (TableChange.RenameTable)renameTableOptional.get());
        }
        return this.internalAlterTable(tableIdent, changes);
    }

    public boolean dropTable(NameIdentifier tableIdent) {
        String databaseName = NameIdentifier.of((String[])tableIdent.namespace().levels()).name();
        return this.tableOperation.drop(databaseName, tableIdent.name());
    }

    public Table createTable(NameIdentifier tableIdent, Column[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        Preconditions.checkArgument((null == sortOrders || sortOrders.length == 0 ? 1 : 0) != 0, (Object)"jdbc-catalog does not support sort orders");
        StringIdentifier identifier = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((identifier != null ? 1 : 0) != 0, (Object)GRAVITINO_ATTRIBUTE_DOES_NOT_EXIST_MSG);
        HashMap resultProperties = Maps.newHashMap(this.jdbcTablePropertiesMetadata.transformToJdbcProperties(properties));
        JdbcColumn[] jdbcColumns = (JdbcColumn[])Arrays.stream(columns).map(column -> (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(column.name())).withType(column.dataType())).withComment(column.comment())).withNullable(column.nullable())).withAutoIncrement(column.autoIncrement())).withDefaultValue(column.defaultValue())).build()).toArray(JdbcColumn[]::new);
        String databaseName = NameIdentifier.of((String[])tableIdent.namespace().levels()).name();
        String tableName = tableIdent.name();
        this.tableOperation.create(databaseName, tableName, jdbcColumns, StringIdentifier.addToComment((StringIdentifier)identifier, (String)comment), resultProperties, partitioning, distribution, indexes);
        return ((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)((JdbcTable.Builder)JdbcTable.builder().withAuditInfo(AuditInfo.builder().withCreator(JdbcCatalogOperations.currentUser()).withCreateTime(Instant.now()).build())).withName(tableName)).withColumns(columns)).withComment(comment)).withProperties(this.jdbcTablePropertiesMetadata.convertFromJdbcProperties(resultProperties))).withPartitioning(partitioning)).withIndexes(indexes)).withDatabaseName(databaseName).withTableOperation(this.tableOperation).build();
    }

    public boolean purgeTable(NameIdentifier tableIdent) throws UnsupportedOperationException {
        String databaseName = NameIdentifier.of((String[])tableIdent.namespace().levels()).name();
        return this.tableOperation.purge(databaseName, tableIdent.name());
    }

    private Table renameTable(NameIdentifier tableIdent, TableChange.RenameTable renameTable) throws NoSuchTableException, IllegalArgumentException {
        Preconditions.checkArgument((!renameTable.getNewSchemaName().isPresent() ? 1 : 0) != 0, (Object)"Does not support rename schema yet");
        String databaseName = NameIdentifier.of((String[])tableIdent.namespace().levels()).name();
        this.tableOperation.rename(databaseName, tableIdent.name(), renameTable.getNewName());
        return this.loadTable(NameIdentifier.of((Namespace)tableIdent.namespace(), (String)renameTable.getNewName()));
    }

    public JDBCDriverInfo getDiverInfo() {
        JDBCDriverInfo jDBCDriverInfo;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                DatabaseMetaData metaData = conn.getMetaData();
                jDBCDriverInfo = new JDBCDriverInfo(metaData.getDriverName(), metaData.getDriverVersion(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw this.exceptionConverter.toGravitinoException(se);
                }
            }
            conn.close();
        }
        return jDBCDriverInfo;
    }

    public void checkJDBCDriverVersion() {
    }

    private Table internalAlterTable(NameIdentifier tableIdent, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        String databaseName = NameIdentifier.of((String[])tableIdent.namespace().levels()).name();
        TableChange[] resultChanges = this.replaceJdbcProperties(changes);
        this.tableOperation.alterTable(databaseName, tableIdent.name(), resultChanges);
        return this.loadTable(tableIdent);
    }

    private TableChange[] replaceJdbcProperties(TableChange[] changes) {
        return (TableChange[])Arrays.stream(changes).flatMap(tableChange -> {
            if (tableChange instanceof TableChange.SetProperty) {
                TableChange.SetProperty setProperty = (TableChange.SetProperty)tableChange;
                Map<String, String> jdbcProperties = this.jdbcTablePropertiesMetadata.transformToJdbcProperties(Collections.singletonMap(setProperty.getProperty(), setProperty.getValue()));
                return jdbcProperties.entrySet().stream().map(entry -> TableChange.setProperty((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
            if (tableChange instanceof TableChange.RemoveProperty) {
                TableChange.RemoveProperty removeProperty = (TableChange.RemoveProperty)tableChange;
                Map<String, String> jdbcProperties = this.jdbcTablePropertiesMetadata.transformToJdbcProperties(Collections.singletonMap(removeProperty.getProperty(), null));
                return jdbcProperties.keySet().stream().map(TableChange::removeProperty);
            }
            return Stream.of(tableChange);
        }).toArray(TableChange[]::new);
    }

    private static String currentUser() {
        return PrincipalUtils.getCurrentUserName();
    }

    public void deregisterDriver(Driver driver) throws SQLException {
        if (driver.getClass().getClassLoader().getClass() == IsolatedClassLoader.CUSTOM_CLASS_LOADER_CLASS) {
            DriverManager.deregisterDriver(driver);
            LOG.info("Driver {} has been deregistered...", (Object)driver);
        }
    }

    public static class JDBCDriverInfo {
        public String name;
        public String version;
        public int majorVersion;
        public int minorVersion;

        public JDBCDriverInfo(String driverName, String version, int majorVersion, int minorVersion) {
            this.name = driverName;
            this.version = version;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }
    }
}

