/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.twill.api.RunId;
import org.apache.twill.api.ServiceController;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.ListenerExecutor;
import org.apache.twill.internal.ServiceListenerAdapter;

public abstract class AbstractExecutionServiceController
implements ServiceController,
Service {
    private final RunId runId;
    private final ListenerExecutors listenerExecutors;
    private final Service serviceDelegate;
    private final SettableFuture<Service.State> terminationFuture;

    protected AbstractExecutionServiceController(RunId runId) {
        this.runId = runId;
        this.listenerExecutors = new ListenerExecutors();
        this.serviceDelegate = new ServiceDelegate();
        this.terminationFuture = SettableFuture.create();
        this.addListener(new ServiceListenerAdapter(){

            @Override
            public void failed(Service.State from, Throwable failure) {
                AbstractExecutionServiceController.this.terminationFuture.setException(failure);
            }

            @Override
            public void terminated(Service.State from) {
                AbstractExecutionServiceController.this.terminationFuture.set((Object)Service.State.TERMINATED);
            }
        }, Threads.SAME_THREAD_EXECUTOR);
    }

    protected abstract void startUp();

    protected abstract void shutDown();

    public final RunId getRunId() {
        return this.runId;
    }

    public Future<? extends ServiceController> terminate() {
        this.stop();
        return Futures.transform(this.terminationFuture, (Function)new Function<Service.State, ServiceController>(){

            public ServiceController apply(Service.State input) {
                return AbstractExecutionServiceController.this;
            }
        });
    }

    public void onRunning(final Runnable runnable, Executor executor) {
        this.addListener(new ServiceListenerAdapter(){

            @Override
            public void running() {
                runnable.run();
            }
        }, executor);
    }

    public void onTerminated(final Runnable runnable, Executor executor) {
        this.addListener(new ServiceListenerAdapter(){

            @Override
            public void failed(Service.State from, Throwable failure) {
                runnable.run();
            }

            @Override
            public void terminated(Service.State from) {
                runnable.run();
            }
        }, executor);
    }

    public void awaitTerminated() throws ExecutionException {
        Uninterruptibles.getUninterruptibly(this.terminationFuture);
    }

    public void awaitTerminated(long timeout, TimeUnit timeoutUnit) throws TimeoutException, ExecutionException {
        Uninterruptibles.getUninterruptibly(this.terminationFuture, (long)timeout, (TimeUnit)timeoutUnit);
    }

    public final void addListener(Service.Listener listener, Executor executor) {
        this.listenerExecutors.addListener(new ListenerExecutor(listener, executor));
    }

    public final ListenableFuture<Service.State> start() {
        this.serviceDelegate.addListener((Service.Listener)this.listenerExecutors, Threads.SAME_THREAD_EXECUTOR);
        return this.serviceDelegate.start();
    }

    public final Service.State startAndWait() {
        return (Service.State)Futures.getUnchecked(this.start());
    }

    public final boolean isRunning() {
        return this.serviceDelegate.isRunning();
    }

    public final Service.State state() {
        return this.serviceDelegate.state();
    }

    public final Service.State stopAndWait() {
        return (Service.State)Futures.getUnchecked(this.stop());
    }

    public final ListenableFuture<Service.State> stop() {
        return this.serviceDelegate.stop();
    }

    protected Executor executor(final Service.State state) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                Thread t = new Thread(command, this.getClass().getSimpleName() + " " + state);
                t.setDaemon(true);
                t.start();
            }
        };
    }

    private static final class ListenerExecutors
    implements Service.Listener {
        private final Queue<ListenerExecutor> listeners = new ConcurrentLinkedQueue<ListenerExecutor>();
        private final AtomicReference<Callback> lastState = new AtomicReference();

        private ListenerExecutors() {
        }

        private synchronized void addListener(ListenerExecutor listener) {
            this.listeners.add(listener);
            Callback callback = this.lastState.get();
            if (callback != null) {
                callback.call(listener);
            }
        }

        public synchronized void starting() {
            this.lastState.set(new Callback(){

                @Override
                public void call(Service.Listener listener) {
                    listener.starting();
                }
            });
            for (ListenerExecutor listener : this.listeners) {
                listener.starting();
            }
        }

        public synchronized void running() {
            this.lastState.set(new Callback(){

                @Override
                public void call(Service.Listener listener) {
                    listener.running();
                }
            });
            for (ListenerExecutor listener : this.listeners) {
                listener.running();
            }
        }

        public synchronized void stopping(final Service.State from) {
            this.lastState.set(new Callback(){

                @Override
                public void call(Service.Listener listener) {
                    listener.stopping(from);
                }
            });
            for (ListenerExecutor listener : this.listeners) {
                listener.stopping(from);
            }
        }

        public synchronized void terminated(final Service.State from) {
            this.lastState.set(new Callback(){

                @Override
                public void call(Service.Listener listener) {
                    listener.terminated(from);
                }
            });
            for (ListenerExecutor listener : this.listeners) {
                listener.terminated(from);
            }
        }

        public synchronized void failed(final Service.State from, final Throwable failure) {
            this.lastState.set(new Callback(){

                @Override
                public void call(Service.Listener listener) {
                    listener.failed(from, failure);
                }
            });
            for (ListenerExecutor listener : this.listeners) {
                listener.failed(from, failure);
            }
        }

        private static interface Callback {
            public void call(Service.Listener var1);
        }
    }

    private final class ServiceDelegate
    extends AbstractIdleService {
        private ServiceDelegate() {
        }

        protected void startUp() throws Exception {
            AbstractExecutionServiceController.this.startUp();
        }

        protected void shutDown() throws Exception {
            AbstractExecutionServiceController.this.shutDown();
        }

        protected Executor executor(Service.State state) {
            return AbstractExecutionServiceController.this.executor(state);
        }
    }
}

