/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.internal;

import com.googlecode.aviator.runtime.function.internal.ReducerState;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Env;
import java.util.Map;

public class ReducerResult
extends AviatorRuntimeJavaType {
    private static final long serialVersionUID = 8804868778622599851L;
    public final ReducerState state;
    public AviatorObject obj;

    public boolean isEmptyState() {
        return this.state == ReducerState.Empty;
    }

    public static ReducerResult withEmpty(AviatorObject obj) {
        return new ReducerResult(ReducerState.Empty, obj);
    }

    public static ReducerResult withCont(AviatorObject obj) {
        return new ReducerResult(ReducerState.Cont, obj);
    }

    public static ReducerResult withBreak(AviatorObject obj) {
        return new ReducerResult(ReducerState.Break, obj);
    }

    public static ReducerResult withReturn(AviatorObject obj) {
        return new ReducerResult(ReducerState.Return, obj);
    }

    private ReducerResult(ReducerState state, AviatorObject obj) {
        super(obj);
        this.state = state;
        this.obj = obj;
        this.metadata = obj.getMetadata();
    }

    @Override
    public AviatorObject deref(Map<String, Object> env) {
        this.obj = this.obj.deref(env);
        return this;
    }

    @Override
    public int innerCompare(AviatorObject other, Map<String, Object> env) {
        return this.obj.innerCompare(other, env);
    }

    @Override
    public AviatorType getAviatorType() {
        return this.obj.getAviatorType();
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        if (this.obj == this) {
            return this;
        }
        return this.obj.getValue(env);
    }

    @Override
    public String toString() {
        Object val = this.getValue(Env.EMPTY_ENV);
        if (val != this) {
            return "<Reducer, " + this.state.name() + ", " + val + ">";
        }
        return "<Reducer, " + this.state.name() + ", this>";
    }

    @Override
    public boolean isNull(Map<String, Object> env) {
        return this.obj.isNull(env);
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    @Override
    public AviatorObject match(AviatorObject other, Map<String, Object> env) {
        return this.obj.match(other, env);
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        return this.obj.neg(env);
    }

    @Override
    public AviatorObject setValue(AviatorObject value, Map<String, Object> env) {
        return this.obj.setValue(value, env);
    }

    @Override
    public AviatorObject not(Map<String, Object> env) {
        return this.obj.not(env);
    }

    @Override
    public String desc(Map<String, Object> env) {
        return this.obj.desc(env);
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        return this.obj.add(other, env);
    }

    @Override
    public AviatorObject bitAnd(AviatorObject other, Map<String, Object> env) {
        return this.obj.bitAnd(other, env);
    }

    @Override
    public AviatorObject bitOr(AviatorObject other, Map<String, Object> env) {
        return this.obj.bitOr(other, env);
    }

    @Override
    public AviatorObject bitXor(AviatorObject other, Map<String, Object> env) {
        return this.obj.bitXor(other, env);
    }

    @Override
    public AviatorObject shiftRight(AviatorObject other, Map<String, Object> env) {
        return this.obj.shiftRight(other, env);
    }

    public boolean equals(Object obj) {
        return this.obj.equals(obj);
    }

    @Override
    public AviatorObject shiftLeft(AviatorObject other, Map<String, Object> env) {
        return this.obj.shiftLeft(other, env);
    }

    @Override
    public AviatorObject unsignedShiftRight(AviatorObject other, Map<String, Object> env) {
        return this.obj.unsignedShiftRight(other, env);
    }

    @Override
    public AviatorObject bitNot(Map<String, Object> env) {
        return this.obj.bitNot(env);
    }

    @Override
    public AviatorObject sub(AviatorObject other, Map<String, Object> env) {
        return this.obj.sub(other, env);
    }

    @Override
    public AviatorObject mod(AviatorObject other, Map<String, Object> env) {
        return this.obj.mod(other, env);
    }

    @Override
    public AviatorObject div(AviatorObject other, Map<String, Object> env) {
        return this.obj.div(other, env);
    }

    @Override
    public AviatorObject mult(AviatorObject other, Map<String, Object> env) {
        return this.obj.mult(other, env);
    }

    @Override
    public Number numberValue(Map<String, Object> env) {
        return this.obj.numberValue(env);
    }

    @Override
    public String stringValue(Map<String, Object> env) {
        return this.obj.stringValue(env);
    }

    @Override
    public boolean booleanValue(Map<String, Object> env) {
        return this.obj.booleanValue(env);
    }

    @Override
    public AviatorObject getElement(Map<String, Object> env, AviatorObject indexObject) {
        return this.obj.getElement(env, indexObject);
    }
}

