/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.s3.credential;

import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialProvider;
import org.apache.gravitino.credential.S3SecretKeyCredential;
import org.apache.gravitino.credential.config.S3CredentialConfig;

public class S3SecretKeyProvider
implements CredentialProvider {
    private String accessKey;
    private String secretKey;

    public void initialize(Map<String, String> properties) {
        S3CredentialConfig s3CredentialConfig = new S3CredentialConfig(properties);
        this.accessKey = s3CredentialConfig.accessKeyID();
        this.secretKey = s3CredentialConfig.secretAccessKey();
    }

    public void close() {
    }

    public String credentialType() {
        return "s3-secret-key";
    }

    public Credential getCredential(CredentialContext context) {
        return new S3SecretKeyCredential(this.accessKey, this.secretKey);
    }
}

