/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential.config;

import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class OSSCredentialConfig
extends Config {
    public static final ConfigEntry<String> OSS_REGION = new ConfigBuilder("oss-region").doc("The region of the OSS service").version("0.8.0").stringConf().create();
    public static final ConfigEntry<String> OSS_ACCESS_KEY_ID = new ConfigBuilder("oss-access-key-id").doc("The static access key ID used to access OSS data").version("0.8.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> OSS_SECRET_ACCESS_KEY = new ConfigBuilder("oss-secret-access-key").doc("The static secret access key used to access OSS data").version("0.8.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> OSS_ROLE_ARN = new ConfigBuilder("oss-role-arn").doc("OSS role arn").version("0.8.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> OSS_EXTERNAL_ID = new ConfigBuilder("oss-external-id").doc("OSS external ID").version("0.8.0").stringConf().create();
    public static final ConfigEntry<Integer> OSS_TOKEN_EXPIRE_IN_SECS = new ConfigBuilder("oss-token-expire-in-secs").doc("OSS token expire in seconds").version("0.8.0").intConf().createWithDefault((Object)3600);

    public OSSCredentialConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String region() {
        return (String)this.get(OSS_REGION);
    }

    @NotNull
    public String ossRoleArn() {
        return (String)this.get(OSS_ROLE_ARN);
    }

    @NotNull
    public String accessKeyID() {
        return (String)this.get(OSS_ACCESS_KEY_ID);
    }

    @NotNull
    public String secretAccessKey() {
        return (String)this.get(OSS_SECRET_ACCESS_KEY);
    }

    public String externalID() {
        return (String)this.get(OSS_EXTERNAL_ID);
    }

    public Integer tokenExpireInSecs() {
        return (Integer)this.get(OSS_TOKEN_EXPIRE_IN_SECS);
    }
}

