/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.cache.ReverseIndexCache;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.utils.NamespaceUtil;

public class ReverseIndexRules {
    public static final ReverseIndexCache.ReverseIndexRule USER_ROLE_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        UserEntity userEntity = (UserEntity)entity;
        if (userEntity.roleNames() != null) {
            userEntity.roleNames().forEach(role -> {
                Namespace ns = NamespaceUtil.ofRole(userEntity.namespace().level(0));
                NameIdentifier nameIdentifier = NameIdentifier.of((Namespace)ns, (String)role);
                reverseIndexCache.put(nameIdentifier, Entity.EntityType.ROLE, key);
            });
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule USER_OWNERSHIP_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        UserEntity userEntity = (UserEntity)entity;
        if (key.relationType() == SupportsRelationOperations.Type.OWNER_REL) {
            reverseIndexCache.put(userEntity.nameIdentifier(), Entity.EntityType.USER, key);
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule GROUP_ROLE_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        GroupEntity groupEntity = (GroupEntity)entity;
        if (groupEntity.roleNames() != null) {
            groupEntity.roleNames().forEach(role -> {
                Namespace ns = NamespaceUtil.ofRole(groupEntity.namespace().level(0));
                NameIdentifier nameIdentifier = NameIdentifier.of((Namespace)ns, (String)role);
                reverseIndexCache.put(nameIdentifier, Entity.EntityType.ROLE, key);
            });
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule GROUP_OWNERSHIP_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        GroupEntity groupEntity = (GroupEntity)entity;
        if (key.relationType() == SupportsRelationOperations.Type.OWNER_REL) {
            reverseIndexCache.put(groupEntity.nameIdentifier(), Entity.EntityType.GROUP, key);
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule ROLE_SECURABLE_OBJECT_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        RoleEntity roleEntity = (RoleEntity)entity;
        if (roleEntity.securableObjects() != null) {
            roleEntity.securableObjects().forEach(securableObject -> {
                Namespace namespace = Namespace.empty();
                Entity.EntityType entityType = Entity.EntityType.METALAKE;
                switch (securableObject.type()) {
                    case METALAKE: {
                        entityType = Entity.EntityType.METALAKE;
                        namespace = NamespaceUtil.ofMetalake();
                        break;
                    }
                    case CATALOG: {
                        entityType = Entity.EntityType.CATALOG;
                        namespace = NamespaceUtil.ofCatalog(roleEntity.namespace().level(0));
                        break;
                    }
                    case SCHEMA: {
                        entityType = Entity.EntityType.SCHEMA;
                        Namespace nsSchema = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofSchema(roleEntity.namespace().level(0), nsSchema.level(0));
                        break;
                    }
                    case TABLE: {
                        entityType = Entity.EntityType.TABLE;
                        Namespace nsTable = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofTable(roleEntity.namespace().level(0), nsTable.level(0), nsTable.level(1));
                        break;
                    }
                    case TOPIC: {
                        entityType = Entity.EntityType.TOPIC;
                        Namespace nsTopic = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofTopic(roleEntity.namespace().level(0), nsTopic.level(0), nsTopic.level(1));
                        break;
                    }
                    case MODEL: {
                        entityType = Entity.EntityType.MODEL;
                        Namespace nsModel = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofModel(roleEntity.namespace().level(0), nsModel.level(0), nsModel.level(1));
                        break;
                    }
                    case FILESET: {
                        entityType = Entity.EntityType.FILESET;
                        Namespace nsFileset = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofFileset(roleEntity.namespace().level(0), nsFileset.level(0), nsFileset.level(1));
                        break;
                    }
                    case TAG: {
                        entityType = Entity.EntityType.TAG;
                        namespace = NamespaceUtil.ofTag(roleEntity.namespace().level(0));
                        break;
                    }
                    case POLICY: {
                        entityType = Entity.EntityType.POLICY;
                        namespace = NamespaceUtil.ofPolicy(roleEntity.namespace().level(0));
                        break;
                    }
                    case JOB_TEMPLATE: {
                        entityType = Entity.EntityType.JOB_TEMPLATE;
                        namespace = NamespaceUtil.ofJobTemplate(roleEntity.namespace().level(0));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Don't support securable object type: " + String.valueOf(securableObject.type()));
                    }
                }
                Namespace securableObjectNamespace = Namespace.of((String[])namespace.levels());
                NameIdentifier securableObjectIdent = NameIdentifier.of((Namespace)securableObjectNamespace, (String)securableObject.name());
                reverseIndexCache.put(securableObjectIdent, entityType, key);
            });
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule GENERIC_METADATA_OBJECT_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        GenericEntity genericEntity = (GenericEntity)entity;
        Entity.EntityType type = entity.type();
        if (genericEntity.name() != null) {
            Object[] levels = genericEntity.name().split("\\.");
            String metalakeName = key.identifier().namespace().levels()[0];
            NameIdentifier objectNameIdentifier = NameIdentifier.of((String[])((String[])ArrayUtils.addFirst((Object[])levels, (Object)metalakeName)));
            reverseIndexCache.put(objectNameIdentifier, type, key);
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule POLICY_SECURABLE_OBJECT_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        PolicyEntity policyEntity = (PolicyEntity)entity;
        NameIdentifier nameIdentifier = NameIdentifier.of((Namespace)policyEntity.namespace(), (String)policyEntity.name());
        reverseIndexCache.put(nameIdentifier, Entity.EntityType.POLICY, key);
    };
    public static final ReverseIndexCache.ReverseIndexRule TAG_SECURABLE_OBJECT_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        TagEntity tagEntity = (TagEntity)entity;
        NameIdentifier nameIdentifier = NameIdentifier.of((Namespace)tagEntity.namespace(), (String)tagEntity.name());
        reverseIndexCache.put(nameIdentifier, Entity.EntityType.TAG, key);
    };
}

