/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.auth.KerberosSecurityTestcase;
import org.apache.zookeeper.server.quorum.auth.KerberosTestUtils;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QuorumKerberosAuthTest
extends KerberosSecurityTestcase {
    private static File keytabFile;

    @BeforeClass
    public static void notOnJdk6() throws Exception {
        String specsVersion = System.getProperty("java.specification.version", "1.6");
        System.out.println("java.specification.version=" + specsVersion);
        Assume.assumeFalse((String)("Skipping test as Java Major version is " + specsVersion), (boolean)"1.6".equals(specsVersion));
    }

    @Before
    public void setUp() throws Exception {
        keytabFile = new File(KerberosTestUtils.getKeytabFile());
        String learnerPrincipal = KerberosTestUtils.getLearnerPrincipal();
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        learnerPrincipal = learnerPrincipal.substring(0, learnerPrincipal.lastIndexOf("@"));
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        QuorumKerberosAuthTest.getKdc().createPrincipal(keytabFile, learnerPrincipal, serverPrincipal);
    }

    @After
    public void tearDown() throws Exception {
        for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
            mainThread.shutdown();
            mainThread.deleteBaseDir();
        }
    }

    @AfterClass
    public static void cleanup() {
        if (keytabFile != null) {
            FileUtils.deleteQuietly((File)keytabFile);
        }
        QuorumKerberosAuthTest.cleanupJaasConfig();
    }

    @Test(timeout=120000L)
    public void testValidCredentials() throws Exception {
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.kerberos.servicePrincipal", serverPrincipal);
        String connectStr = this.startQuorum(3, authConfigs, 3, false);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    static {
        String keytabFilePath = FilenameUtils.normalize((String)KerberosTestUtils.getKeytabFile(), (boolean)true);
        String jaasEntries = new String("QuorumServer {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=false\n       principal=\"" + KerberosTestUtils.getServerPrincipal() + "\";\n};\nQuorumLearner {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=false\n       principal=\"" + KerberosTestUtils.getLearnerPrincipal() + "\";\n};\n");
        QuorumKerberosAuthTest.setupJaasConfig(jaasEntries);
    }
}

