/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import org.apache.zookeeper.SaslServerPrincipal;
import org.apache.zookeeper.ZKTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ClientCanonicalizeTest
extends ZKTestCase {
    @Test
    public void testClientCanonicalization() throws IOException, InterruptedException {
        SaslServerPrincipal.WrapperInetSocketAddress addr = (SaslServerPrincipal.WrapperInetSocketAddress)Mockito.mock(SaslServerPrincipal.WrapperInetSocketAddress.class);
        SaslServerPrincipal.WrapperInetAddress ia = (SaslServerPrincipal.WrapperInetAddress)Mockito.mock(SaslServerPrincipal.WrapperInetAddress.class);
        Mockito.when((Object)addr.getHostName()).thenReturn((Object)"zookeeper.apache.org");
        Mockito.when((Object)addr.getAddress()).thenReturn((Object)ia);
        Mockito.when((Object)ia.getCanonicalHostName()).thenReturn((Object)"zk1.apache.org");
        Mockito.when((Object)ia.getHostAddress()).thenReturn((Object)"127.0.0.1");
        String principal = SaslServerPrincipal.getServerPrincipal((SaslServerPrincipal.WrapperInetSocketAddress)addr);
        Assert.assertEquals((String)"The computed principal does not appear to have been canonicalized", (Object)"zookeeper/zk1.apache.org", (Object)principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientNoCanonicalization() throws IOException, InterruptedException {
        SaslServerPrincipal.WrapperInetSocketAddress addr = (SaslServerPrincipal.WrapperInetSocketAddress)Mockito.mock(SaslServerPrincipal.WrapperInetSocketAddress.class);
        SaslServerPrincipal.WrapperInetAddress ia = (SaslServerPrincipal.WrapperInetAddress)Mockito.mock(SaslServerPrincipal.WrapperInetAddress.class);
        Mockito.when((Object)addr.getHostName()).thenReturn((Object)"zookeeper.apache.org");
        Mockito.when((Object)addr.getAddress()).thenReturn((Object)ia);
        Mockito.when((Object)ia.getCanonicalHostName()).thenReturn((Object)"zk1.apache.org");
        Mockito.when((Object)ia.getHostAddress()).thenReturn((Object)"127.0.0.1");
        System.setProperty("zookeeper.sasl.client.canonicalize.hostname", "false");
        try {
            String principal = SaslServerPrincipal.getServerPrincipal((SaslServerPrincipal.WrapperInetSocketAddress)addr);
            Assert.assertEquals((String)"The computed principal does appears to have been canonicalized incorrectly", (Object)"zookeeper/zookeeper.apache.org", (Object)principal);
        }
        finally {
            System.setProperty("zookeeper.sasl.client.canonicalize.hostname", "true");
        }
    }

    @Test
    public void testClientCanonicalizationToIp() throws IOException, InterruptedException {
        SaslServerPrincipal.WrapperInetSocketAddress addr = (SaslServerPrincipal.WrapperInetSocketAddress)Mockito.mock(SaslServerPrincipal.WrapperInetSocketAddress.class);
        SaslServerPrincipal.WrapperInetAddress ia = (SaslServerPrincipal.WrapperInetAddress)Mockito.mock(SaslServerPrincipal.WrapperInetAddress.class);
        Mockito.when((Object)addr.getHostName()).thenReturn((Object)"zookeeper.apache.org");
        Mockito.when((Object)addr.getAddress()).thenReturn((Object)ia);
        Mockito.when((Object)ia.getCanonicalHostName()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)ia.getHostAddress()).thenReturn((Object)"127.0.0.1");
        String principal = SaslServerPrincipal.getServerPrincipal((SaslServerPrincipal.WrapperInetSocketAddress)addr);
        Assert.assertEquals((String)"The computed principal does appear to have falled back to the original host name", (Object)"zookeeper/zookeeper.apache.org", (Object)principal);
    }
}

