/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.gravitino.credential.CredentialProvider;
import org.apache.gravitino.credential.CredentialProviderFactory;
import org.apache.gravitino.credential.config.CredentialConfig;

public class CredentialUtils {
    public static Map<String, CredentialProvider> loadCredentialProviders(Map<String, String> catalogProperties) {
        CredentialConfig credentialConfig = new CredentialConfig(catalogProperties);
        List credentialProviders = (List)credentialConfig.get(CredentialConfig.CREDENTIAL_PROVIDERS);
        return credentialProviders.stream().collect(Collectors.toMap(String::toString, credentialType -> CredentialProviderFactory.create(credentialType, catalogProperties)));
    }

    public static Set<String> getCredentialProvidersByOrder(Supplier<Map<String, String>> ... propertiesSuppliers) {
        for (Supplier<Map<String, String>> supplier : propertiesSuppliers) {
            Map<String, String> properties = supplier.get();
            Set<String> providers = CredentialUtils.getCredentialProvidersFromProperties(properties);
            if (providers.isEmpty()) continue;
            return providers;
        }
        return Collections.emptySet();
    }

    private static Set<String> getCredentialProvidersFromProperties(Map<String, String> properties) {
        if (properties == null) {
            return Collections.emptySet();
        }
        CredentialConfig credentialConfig = new CredentialConfig(properties);
        return ((List)credentialConfig.get(CredentialConfig.CREDENTIAL_PROVIDERS)).stream().collect(Collectors.toSet());
    }
}

