/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.io.IOException;
import java.util.Optional;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.TableSnapshot;
import org.apache.paimon.utils.SnapshotLoader;

public class SnapshotLoaderImpl
implements SnapshotLoader {
    private final CatalogLoader catalogLoader;
    private final Identifier identifier;

    public SnapshotLoaderImpl(CatalogLoader catalogLoader, Identifier identifier) {
        this.catalogLoader = catalogLoader;
        this.identifier = identifier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Snapshot> load() throws IOException {
        try (Catalog catalog = this.catalogLoader.load();){
            Optional<Snapshot> optional = catalog.loadSnapshot(this.identifier).map(TableSnapshot::snapshot);
            return optional;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rollback(Instant instant) throws IOException {
        try (Catalog catalog = this.catalogLoader.load();){
            catalog.rollbackTo(this.identifier, instant);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SnapshotLoader copyWithBranch(String branch) {
        return new SnapshotLoaderImpl(this.catalogLoader, new Identifier(this.identifier.getDatabaseName(), this.identifier.getTableName(), branch));
    }
}

