/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FallbackReadFileStoreTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataTableBatchScan;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.DataTableStreamScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class ReadOptimizedTable
implements DataTable,
ReadonlyTable {
    public static final String READ_OPTIMIZED = "ro";
    private final FileStoreTable wrapped;

    public ReadOptimizedTable(FileStoreTable wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Optional<Snapshot> latestSnapshot() {
        return this.wrapped.latestSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.wrapped.manifestListReader();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.wrapped.manifestFileReader();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.wrapped.indexManifestFileReader();
    }

    @Override
    public String name() {
        return this.wrapped.name() + "$" + READ_OPTIMIZED;
    }

    @Override
    public RowType rowType() {
        return this.wrapped.rowType();
    }

    @Override
    public List<String> partitionKeys() {
        return this.wrapped.partitionKeys();
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return this.wrapped.primaryKeys();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return this.newSnapshotReader(this.wrapped);
    }

    private SnapshotReader newSnapshotReader(FileStoreTable wrapped) {
        if (!wrapped.schema().primaryKeys().isEmpty()) {
            return wrapped.newSnapshotReader().withLevel(this.coreOptions().numLevels() - 1).enableValueFilter();
        }
        return wrapped.newSnapshotReader();
    }

    @Override
    public DataTableScan newScan() {
        if (this.wrapped instanceof FallbackReadFileStoreTable) {
            FallbackReadFileStoreTable table = (FallbackReadFileStoreTable)this.wrapped;
            return new FallbackReadFileStoreTable.FallbackReadScan(this.newScan(table.wrapped()), this.newScan(table.fallback()));
        }
        return this.newScan(this.wrapped);
    }

    private DataTableScan newScan(FileStoreTable wrapped) {
        CoreOptions options = wrapped.coreOptions();
        return new DataTableBatchScan(wrapped.schema(), options, this.newSnapshotReader(wrapped), wrapped.catalogEnvironment().tableQueryAuth(options));
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        if (!this.wrapped.schema().primaryKeys().isEmpty()) {
            throw new UnsupportedOperationException("Unsupported streaming scan for read optimized table");
        }
        return new DataTableStreamScan(this.wrapped.schema(), this.coreOptions(), this.newSnapshotReader(), this.snapshotManager(), this.changelogManager(), this.wrapped.supportStreamingReadOverwrite(), this.wrapped.catalogEnvironment().tableQueryAuth(this.coreOptions()), !this.wrapped.schema().primaryKeys().isEmpty());
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public ChangelogManager changelogManager() {
        return this.wrapped.changelogManager();
    }

    @Override
    public ConsumerManager consumerManager() {
        return this.wrapped.consumerManager();
    }

    @Override
    public SchemaManager schemaManager() {
        return this.wrapped.schemaManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        return this.wrapped.branchManager();
    }

    @Override
    public DataTable switchToBranch(String branchName) {
        return new ReadOptimizedTable(this.wrapped.switchToBranch(branchName));
    }

    @Override
    public InnerTableRead newRead() {
        return this.wrapped.newRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new ReadOptimizedTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions));
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }
}

