/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.splitread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.ProjectedRow;

public class IncrementalDiffSplitRead
implements SplitRead<InternalRow> {
    private static final int BEFORE_LEVEL = Integer.MIN_VALUE;
    private static final int AFTER_LEVEL = Integer.MAX_VALUE;
    private final MergeFileSplitRead mergeRead;
    private boolean forceKeepDelete = false;
    @Nullable
    private RowType readType;

    public IncrementalDiffSplitRead(MergeFileSplitRead mergeRead) {
        this.mergeRead = mergeRead;
    }

    @Override
    public SplitRead<InternalRow> forceKeepDelete() {
        this.forceKeepDelete = true;
        return this;
    }

    @Override
    public SplitRead<InternalRow> withIOManager(@Nullable IOManager ioManager) {
        this.mergeRead.withIOManager(ioManager);
        return this;
    }

    @Override
    public SplitRead<InternalRow> withReadType(RowType readType) {
        this.readType = readType;
        return this;
    }

    @Override
    public SplitRead<InternalRow> withFilter(@Nullable Predicate predicate) {
        this.mergeRead.withFilter(predicate);
        return this;
    }

    @Override
    public RecordReader<InternalRow> createReader(DataSplit split) throws IOException {
        RecordReader reader = IncrementalDiffSplitRead.readDiff(this.mergeRead.createMergeReader(split.partition(), split.bucket(), split.beforeFiles(), split.beforeDeletionFiles().orElse(null), this.forceKeepDelete), this.mergeRead.createMergeReader(split.partition(), split.bucket(), split.dataFiles(), split.deletionFiles().orElse(null), this.forceKeepDelete), this.mergeRead.keyComparator(), this.mergeRead.createUdsComparator(), this.mergeRead.mergeSorter(), this.forceKeepDelete);
        if (this.readType != null) {
            ProjectedRow projectedRow = ProjectedRow.from((RowType)this.readType, (RowType)this.mergeRead.tableSchema().logicalRowType());
            reader = reader.transform(kv -> kv.replaceValue((InternalRow)projectedRow.replaceRow(kv.value())));
        }
        return KeyValueTableRead.unwrap(reader);
    }

    private static RecordReader<KeyValue> readDiff(RecordReader<KeyValue> beforeReader, RecordReader<KeyValue> afterReader, Comparator<InternalRow> keyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeSorter sorter, boolean keepDelete) throws IOException {
        return sorter.mergeSortNoSpill(Arrays.asList(() -> IncrementalDiffSplitRead.wrapLevelToReader(beforeReader, Integer.MIN_VALUE), () -> IncrementalDiffSplitRead.wrapLevelToReader(afterReader, Integer.MAX_VALUE)), keyComparator, userDefinedSeqComparator, new DiffMerger(keepDelete, InternalSerializers.create((RowType)sorter.valueType())));
    }

    private static RecordReader<KeyValue> wrapLevelToReader(final RecordReader<KeyValue> reader, final int level) {
        return new RecordReader<KeyValue>(){

            @Nullable
            public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
                final RecordReader.RecordIterator batch = reader.readBatch();
                if (batch == null) {
                    return null;
                }
                return new RecordReader.RecordIterator<KeyValue>(){

                    @Nullable
                    public KeyValue next() throws IOException {
                        KeyValue kv = (KeyValue)batch.next();
                        if (kv != null) {
                            kv.setLevel(level);
                        }
                        return kv;
                    }

                    public void releaseBatch() {
                        batch.releaseBatch();
                    }
                };
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }

    private static class DiffMerger
    implements MergeFunctionWrapper<KeyValue> {
        private final boolean keepDelete;
        private final InternalRowSerializer serializer1;
        private final InternalRowSerializer serializer2;
        private final List<KeyValue> kvs = new ArrayList<KeyValue>();

        public DiffMerger(boolean keepDelete, InternalRowSerializer serializer) {
            this.keepDelete = keepDelete;
            this.serializer1 = serializer;
            this.serializer2 = serializer.duplicate();
        }

        @Override
        public void reset() {
            this.kvs.clear();
        }

        @Override
        public void add(KeyValue kv) {
            this.kvs.add(kv);
        }

        @Override
        @Nullable
        public KeyValue getResult() {
            KeyValue toReturn = null;
            if (this.kvs.size() == 1) {
                KeyValue kv = this.kvs.get(0);
                if (kv.level() == Integer.MIN_VALUE) {
                    if (this.keepDelete && kv.isAdd()) {
                        return kv.replaceValueKind(RowKind.DELETE);
                    }
                } else {
                    toReturn = kv;
                }
            } else if (this.kvs.size() == 2) {
                KeyValue before = this.kvs.get(0);
                KeyValue after = this.kvs.get(1);
                if (after.level() == Integer.MAX_VALUE && !this.valueAndRowKindEquals(before, after)) {
                    toReturn = after;
                }
            } else {
                throw new IllegalArgumentException("Illegal kv number: " + this.kvs.size());
            }
            if (toReturn != null && (this.keepDelete || toReturn.isAdd())) {
                return toReturn;
            }
            return null;
        }

        private boolean valueAndRowKindEquals(KeyValue before, KeyValue after) {
            return this.serializer1.toBinaryRow(before.value()).equals((Object)this.serializer2.toBinaryRow(after.value())) && before.isAdd() == after.isAdd();
        }
    }
}

