/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCreationTimeStartingScanner
extends ReadPlanStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FileCreationTimeStartingScanner.class);
    private final long startupMillis;

    public FileCreationTimeStartingScanner(SnapshotManager snapshotManager, long startupMillis) {
        super(snapshotManager);
        this.startupMillis = startupMillis;
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        Long startingSnapshotId = this.snapshotManager.latestSnapshotId();
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return null;
        }
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(startingSnapshotId).withManifestEntryFilter((Filter<ManifestEntry>)((Filter)entry -> entry.file().creationTimeEpochMillis() >= this.startupMillis));
    }
}

