/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.metrics.Counter;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.metrics.CompactTimer;

public class CompactionMetrics {
    private static final String GROUP_NAME = "compaction";
    public static final String MAX_LEVEL0_FILE_COUNT = "maxLevel0FileCount";
    public static final String AVG_LEVEL0_FILE_COUNT = "avgLevel0FileCount";
    public static final String COMPACTION_THREAD_BUSY = "compactionThreadBusy";
    public static final String AVG_COMPACTION_TIME = "avgCompactionTime";
    public static final String COMPACTION_COMPLETED_COUNT = "compactionCompletedCount";
    public static final String COMPACTION_QUEUED_COUNT = "compactionQueuedCount";
    public static final String MAX_COMPACTION_INPUT_SIZE = "maxCompactionInputSize";
    public static final String MAX_COMPACTION_OUTPUT_SIZE = "maxCompactionOutputSize";
    public static final String AVG_COMPACTION_INPUT_SIZE = "avgCompactionInputSize";
    public static final String AVG_COMPACTION_OUTPUT_SIZE = "avgCompactionOutputSize";
    public static final String MAX_TOTAL_FILE_SIZE = "maxTotalFileSize";
    public static final String AVG_TOTAL_FILE_SIZE = "avgTotalFileSize";
    private static final long BUSY_MEASURE_MILLIS = 60000L;
    private static final int COMPACTION_TIME_WINDOW = 100;
    private final MetricGroup metricGroup;
    private final Map<PartitionAndBucket, ReporterImpl> reporters;
    private final Map<Long, CompactTimer> compactTimers;
    private final Queue<Long> compactionTimes;
    private Counter compactionsCompletedCounter;
    private Counter compactionsQueuedCounter;

    public CompactionMetrics(MetricRegistry registry, String tableName) {
        this.metricGroup = registry.createTableMetricGroup(GROUP_NAME, tableName);
        this.reporters = new HashMap<PartitionAndBucket, ReporterImpl>();
        this.compactTimers = new ConcurrentHashMap<Long, CompactTimer>();
        this.compactionTimes = new ConcurrentLinkedQueue<Long>();
        this.registerGenericCompactionMetrics();
    }

    @VisibleForTesting
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    private void registerGenericCompactionMetrics() {
        this.metricGroup.gauge(MAX_LEVEL0_FILE_COUNT, () -> this.getLevel0FileCountStream().max().orElse(-1L));
        this.metricGroup.gauge(AVG_LEVEL0_FILE_COUNT, () -> this.getLevel0FileCountStream().average().orElse(-1.0));
        this.metricGroup.gauge(MAX_COMPACTION_INPUT_SIZE, () -> this.getCompactionInputSizeStream().max().orElse(-1L));
        this.metricGroup.gauge(MAX_COMPACTION_OUTPUT_SIZE, () -> this.getCompactionOutputSizeStream().max().orElse(-1L));
        this.metricGroup.gauge(AVG_COMPACTION_INPUT_SIZE, () -> this.getCompactionInputSizeStream().average().orElse(-1.0));
        this.metricGroup.gauge(AVG_COMPACTION_OUTPUT_SIZE, () -> this.getCompactionOutputSizeStream().average().orElse(-1.0));
        this.metricGroup.gauge(AVG_COMPACTION_TIME, () -> this.getCompactionTimeStream().average().orElse(0.0));
        this.metricGroup.gauge(COMPACTION_THREAD_BUSY, () -> this.getCompactBusyStream().sum());
        this.compactionsCompletedCounter = this.metricGroup.counter(COMPACTION_COMPLETED_COUNT);
        this.compactionsQueuedCounter = this.metricGroup.counter(COMPACTION_QUEUED_COUNT);
        this.metricGroup.gauge(MAX_TOTAL_FILE_SIZE, () -> this.getTotalFileSizeStream().max().orElse(-1L));
        this.metricGroup.gauge(AVG_TOTAL_FILE_SIZE, () -> this.getTotalFileSizeStream().average().orElse(-1.0));
    }

    private LongStream getLevel0FileCountStream() {
        return this.reporters.values().stream().mapToLong(r -> ((ReporterImpl)r).level0FileCount);
    }

    private LongStream getCompactionInputSizeStream() {
        return this.reporters.values().stream().mapToLong(r -> ((ReporterImpl)r).compactionInputSize);
    }

    private LongStream getCompactionOutputSizeStream() {
        return this.reporters.values().stream().mapToLong(r -> ((ReporterImpl)r).compactionOutputSize);
    }

    private DoubleStream getCompactBusyStream() {
        return this.compactTimers.values().stream().mapToDouble(t -> 100.0 * (double)t.calculateLength() / 60000.0);
    }

    private DoubleStream getCompactionTimeStream() {
        return this.compactionTimes.stream().mapToDouble(Long::doubleValue);
    }

    @VisibleForTesting
    public LongStream getTotalFileSizeStream() {
        return this.reporters.values().stream().mapToLong(r -> ((ReporterImpl)r).totalFileSize);
    }

    public void close() {
        this.metricGroup.close();
    }

    public Reporter createReporter(BinaryRow partition, int bucket) {
        PartitionAndBucket key = new PartitionAndBucket(partition, bucket);
        ReporterImpl reporter = new ReporterImpl(key);
        this.reporters.put(key, reporter);
        return reporter;
    }

    private static class PartitionAndBucket {
        private final BinaryRow partition;
        private final int bucket;

        private PartitionAndBucket(BinaryRow partition, int bucket) {
            this.partition = partition;
            this.bucket = bucket;
        }

        public int hashCode() {
            return Objects.hash(this.partition, this.bucket);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartitionAndBucket)) {
                return false;
            }
            PartitionAndBucket other = (PartitionAndBucket)o;
            return Objects.equals(this.partition, other.partition) && this.bucket == other.bucket;
        }
    }

    private class ReporterImpl
    implements Reporter {
        private final PartitionAndBucket key;
        private long level0FileCount;
        private long compactionInputSize = 0L;
        private long compactionOutputSize = 0L;
        private long totalFileSize = 0L;

        private ReporterImpl(PartitionAndBucket key) {
            this.key = key;
            this.level0FileCount = 0L;
        }

        @Override
        public CompactTimer getCompactTimer() {
            return CompactionMetrics.this.compactTimers.computeIfAbsent(Thread.currentThread().getId(), ignore -> new CompactTimer(60000L));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reportCompactionTime(long time) {
            Queue queue = CompactionMetrics.this.compactionTimes;
            synchronized (queue) {
                CompactionMetrics.this.compactionTimes.add(time);
                if (CompactionMetrics.this.compactionTimes.size() > 100) {
                    CompactionMetrics.this.compactionTimes.poll();
                }
            }
        }

        @Override
        public void reportCompactionInputSize(long bytes) {
            this.compactionInputSize = bytes;
        }

        @Override
        public void reportCompactionOutputSize(long bytes) {
            this.compactionOutputSize = bytes;
        }

        @Override
        public void reportTotalFileSize(long bytes) {
            this.totalFileSize = bytes;
        }

        @Override
        public void reportLevel0FileCount(long count) {
            this.level0FileCount = count;
        }

        @Override
        public void increaseCompactionsCompletedCount() {
            CompactionMetrics.this.compactionsCompletedCounter.inc();
        }

        @Override
        public void increaseCompactionsQueuedCount() {
            CompactionMetrics.this.compactionsQueuedCounter.inc();
        }

        @Override
        public void decreaseCompactionsQueuedCount() {
            CompactionMetrics.this.compactionsQueuedCounter.dec();
        }

        @Override
        public void unregister() {
            CompactionMetrics.this.reporters.remove(this.key);
        }
    }

    public static interface Reporter {
        public CompactTimer getCompactTimer();

        public void reportLevel0FileCount(long var1);

        public void reportCompactionTime(long var1);

        public void increaseCompactionsCompletedCount();

        public void increaseCompactionsQueuedCount();

        public void decreaseCompactionsQueuedCount();

        public void reportCompactionInputSize(long var1);

        public void reportCompactionOutputSize(long var1);

        public void reportTotalFileSize(long var1);

        public void unregister();
    }
}

