/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.kafka;

import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.catalog.kafka.KafkaTopicPropertiesMetadata;
import org.apache.gravitino.connector.BaseTopic;
import org.apache.kafka.clients.admin.NewTopic;

public class KafkaTopic
extends BaseTopic {
    public NewTopic toKafkaTopic(KafkaTopicPropertiesMetadata propertiesMetadata) {
        Optional<Integer> partitionCount = Optional.ofNullable(Integer.valueOf((Integer)propertiesMetadata.getOrDefault(this.properties(), "partition-count")));
        Optional<Short> replicationFactor = Optional.ofNullable(Short.valueOf((Short)propertiesMetadata.getOrDefault(this.properties(), "replication-factor")));
        return new NewTopic(this.name, partitionCount, replicationFactor);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseTopic.BaseTopicBuilder<Builder, KafkaTopic> {
        protected KafkaTopic internalBuild() {
            KafkaTopic topic = new KafkaTopic();
            topic.name = this.name;
            topic.comment = this.comment;
            topic.properties = this.properties;
            topic.auditInfo = (Audit)this.auditInfo;
            return topic;
        }
    }
}

