/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class BufferedMutatorParams
implements Cloneable {
    static final int UNSET = -1;
    private final TableName tableName;
    private long writeBufferSize = -1L;
    private int maxKeyValueSize = -1;
    private ExecutorService pool = null;
    private String implementationClassName = null;
    private int rpcTimeout = -1;
    private int operationTimeout = -1;
    private BufferedMutator.ExceptionListener listener = new BufferedMutator.ExceptionListener(){

        @Override
        public void onException(RetriesExhaustedWithDetailsException exception, BufferedMutator bufferedMutator) throws RetriesExhaustedWithDetailsException {
            throw exception;
        }
    };

    public BufferedMutatorParams(TableName tableName) {
        this.tableName = tableName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public BufferedMutatorParams rpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
        return this;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public BufferedMutatorParams opertationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public BufferedMutatorParams writeBufferSize(long writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    public BufferedMutatorParams maxKeyValueSize(int maxKeyValueSize) {
        this.maxKeyValueSize = maxKeyValueSize;
        return this;
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    public BufferedMutatorParams pool(ExecutorService pool) {
        this.pool = pool;
        return this;
    }

    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    public BufferedMutatorParams implementationClassName(String implementationClassName) {
        this.implementationClassName = implementationClassName;
        return this;
    }

    public BufferedMutator.ExceptionListener getListener() {
        return this.listener;
    }

    public BufferedMutatorParams listener(BufferedMutator.ExceptionListener listener) {
        this.listener = listener;
        return this;
    }

    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="The clone below is complete")
    public BufferedMutatorParams clone() {
        BufferedMutatorParams clone = new BufferedMutatorParams(this.tableName);
        clone.writeBufferSize = this.writeBufferSize;
        clone.maxKeyValueSize = this.maxKeyValueSize;
        clone.pool = this.pool;
        clone.listener = this.listener;
        clone.implementationClassName = this.implementationClassName;
        return clone;
    }
}

