/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;

public class GrailsApplicationContext
extends GenericApplicationContext
implements GroovyObject {
    protected MetaClass metaClass;
    private BeanWrapper ctxBean = new BeanWrapperImpl(this);
    private ThemeSource themeSource;
    private static final String GRAILS_ENVIRONMENT_BEAN_NAME = "springEnvironment";

    public GrailsApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory) {
        super(defaultListableBeanFactory);
        this.metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.getClass());
    }

    public GrailsApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory, ApplicationContext applicationContext) {
        super(defaultListableBeanFactory, applicationContext);
        this.metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.getClass());
    }

    public GrailsApplicationContext(ApplicationContext parent) throws BeansException {
        super(parent);
        this.metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.getClass());
    }

    public GrailsApplicationContext() throws BeansException {
        this.metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.getClass());
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return super.containsBeanDefinition(beanName);
    }

    @Override
    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public Object getProperty(String property) {
        if (this.containsBean(property)) {
            return this.getBean(property);
        }
        if (this.ctxBean.isReadableProperty(property)) {
            return this.ctxBean.getPropertyValue(property);
        }
        return null;
    }

    @Override
    public Object invokeMethod(String name, Object args) {
        return this.metaClass.invokeMethod((Object)this, name, args);
    }

    @Override
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource(this);
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }

    @Override
    public void setProperty(String property, Object newValue) {
        if (newValue instanceof BeanDefinition) {
            if (this.containsBean(property)) {
                this.removeBeanDefinition(property);
            }
            this.registerBeanDefinition(property, (BeanDefinition)newValue);
        } else {
            this.metaClass.setProperty(this, property, newValue);
        }
    }

    public void registerSingleton(String name, Class<?> clazz) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClass(clazz);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    public void registerSingleton(String name, Class<?> clazz, MutablePropertyValues pvs) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClass(clazz);
        bd.setPropertyValues(pvs);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    public void registerPrototype(String name, Class<?> clazz) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setScope("prototype");
        bd.setBeanClass(clazz);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    public void registerPrototype(String name, Class<?> clazz, MutablePropertyValues pvs) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setScope("prototype");
        bd.setBeanClass(clazz);
        bd.setPropertyValues(pvs);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    @Override
    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        ((DefaultListableBeanFactory)beanFactory).destroySingleton("environment");
        beanFactory.registerSingleton(GRAILS_ENVIRONMENT_BEAN_NAME, this.getEnvironment());
    }

    @Override
    protected void assertBeanFactoryActive() {
    }
}

