/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.jdbc;

import org.grails.datastore.gorm.jdbc.PropertyOrigin;
import org.springframework.beans.PropertyValue;

class OriginCapablePropertyValue
extends PropertyValue {
    private static final String ATTRIBUTE_PROPERTY_ORIGIN = "propertyOrigin";
    private final PropertyOrigin origin;

    private OriginCapablePropertyValue(PropertyValue propertyValue) {
        this(propertyValue.getName(), propertyValue.getValue(), (PropertyOrigin)propertyValue.getAttribute(ATTRIBUTE_PROPERTY_ORIGIN));
    }

    OriginCapablePropertyValue(String name, Object value, PropertyOrigin origin) {
        super(name, value);
        this.origin = origin;
        this.setAttribute(ATTRIBUTE_PROPERTY_ORIGIN, origin);
    }

    private PropertyOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public String toString() {
        String name = this.origin != null ? this.origin.getName() : this.getName();
        String source = this.origin.getSource() != null ? this.origin.getSource().getName() : "unknown";
        return "'" + name + "' from '" + source + "'";
    }

    static PropertyOrigin getOrigin(PropertyValue propertyValue) {
        if (propertyValue instanceof OriginCapablePropertyValue) {
            return ((OriginCapablePropertyValue)propertyValue).getOrigin();
        }
        return new OriginCapablePropertyValue(propertyValue).getOrigin();
    }
}

