/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsParseException;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultSettingsReader
implements SettingsReader {
    @Override
    public Settings read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        Settings settings = this.read(ReaderFactory.newXmlReader(input), options);
        return settings;
    }

    @Override
    public Settings read(Reader input, Map<String, ?> options) throws IOException {
        Settings settings;
        block8: {
            Objects.requireNonNull(input, "input cannot be null");
            Reader in = input;
            try {
                settings = new SettingsXpp3Reader().read(in, this.isStrict(options));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
                }
            }
            in.close();
        }
        return settings;
    }

    @Override
    public Settings read(InputStream input, Map<String, ?> options) throws IOException {
        Settings settings;
        block8: {
            Objects.requireNonNull(input, "input cannot be null");
            InputStream in = input;
            try {
                settings = new SettingsXpp3Reader().read(in, this.isStrict(options));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
                }
            }
            in.close();
        }
        return settings;
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.settings.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

