/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.DoubleRange;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DoubleRangeTest
extends AbstractLangTest {
    private DoubleRange range1;
    private DoubleRange range2;
    private DoubleRange range3;
    private DoubleRange rangeFull;

    DoubleRangeTest() {
    }

    private static DoubleRange of(double min, double max) {
        return DoubleRange.of((double)min, (double)max);
    }

    private static DoubleRange of(Double min, Double max) {
        return DoubleRange.of((Double)min, (Double)max);
    }

    @BeforeEach
    public void setUp() {
        this.range1 = DoubleRangeTest.of(10.0, 20.0);
        this.range2 = DoubleRangeTest.of(10.0, 20.0);
        this.range3 = DoubleRangeTest.of(-2.0, -1.0);
        this.rangeFull = DoubleRangeTest.of(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    @Test
    void testContainsInt() {
        Assertions.assertFalse((boolean)this.range1.contains(null));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Double.MIN_VALUE));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Double.MAX_VALUE));
        Assertions.assertFalse((boolean)this.range1.contains((Object)5.0));
        Assertions.assertTrue((boolean)this.range1.contains((Object)10.0));
        Assertions.assertTrue((boolean)this.range1.contains((Object)15.0));
        Assertions.assertTrue((boolean)this.range1.contains((Object)20.0));
        Assertions.assertFalse((boolean)this.range1.contains((Object)25.0));
    }

    @Test
    void testContainsRange() {
        Assertions.assertFalse((boolean)this.range1.containsRange(null));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(12.0), (Comparable)Double.valueOf(18.0))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(12.0, 18.0)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(32.0), (Comparable)Double.valueOf(45.0))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(32.0, 45.0)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(2.0), (Comparable)Double.valueOf(8.0))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(2.0, 8.0)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(10.0, 20.0)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(9.0), (Comparable)Double.valueOf(14.0))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(9.0, 14.0)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(16.0), (Comparable)Double.valueOf(21.0))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(16.0, 21.0)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(19.0))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(10.0, 19.0)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(21.0))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(10.0, 21.0)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(11.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(11.0, 20.0)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(9.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(9.0, 20.0)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Double.valueOf(-11.0), (Comparable)Double.valueOf(-18.0))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)DoubleRangeTest.of(-11.0, -18.0)));
    }

    @Test
    void testElementCompareTo() {
        LangAssertions.assertNullPointerException(() -> this.range1.elementCompareTo(null));
        Assertions.assertEquals((int)-1, (int)this.range1.elementCompareTo((Object)5.0));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)10.0));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)15.0));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)20.0));
        Assertions.assertEquals((int)1, (int)this.range1.elementCompareTo((Object)25.0));
    }

    @Test
    void testEqualsObject() {
        Assertions.assertEquals((Object)this.range1, (Object)this.range1);
        Assertions.assertEquals((Object)this.range1, (Object)this.range2);
        Assertions.assertEquals((Object)this.range2, (Object)this.range2);
        Assertions.assertEquals((Object)this.range1, (Object)this.range1);
        Assertions.assertEquals((Object)this.range2, (Object)this.range2);
        Assertions.assertEquals((Object)this.range3, (Object)this.range3);
        Assertions.assertNotEquals((Object)this.range2, (Object)this.range3);
        Assertions.assertNotEquals(null, (Object)this.range2);
        Assertions.assertNotEquals((Object)"Ni!", (Object)this.range2);
    }

    @Test
    void testFit() {
        Assertions.assertEquals((Double)((Double)this.range1.getMinimum()), (double)this.range1.fit(Double.MIN_VALUE));
        Assertions.assertEquals((Double)((Double)this.range1.getMinimum()), (Double)((Double)this.range1.fit((Object)((Double)this.range1.getMinimum()))));
        Assertions.assertEquals((Double)((Double)this.range1.getMaximum()), (double)this.range1.fit(Double.MAX_VALUE));
        Assertions.assertEquals((Double)((Double)this.range1.getMaximum()), (Double)((Double)this.range1.fit((Object)((Double)this.range1.getMaximum()))));
        Assertions.assertEquals((double)15.0, (double)this.range1.fit(15.0));
        Assertions.assertEquals((double)15.0, (double)this.range1.fit(15.0));
        Assertions.assertEquals((double)15.0, (double)this.range1.fit(15.0));
    }

    @Test
    void testFitNull() {
        LangAssertions.assertNullPointerException(() -> this.range1.fit(null));
    }

    @Test
    void testGetMaximum() {
        Assertions.assertEquals((double)20.0, (Double)((Double)this.range1.getMaximum()));
    }

    @Test
    void testGetMinimum() {
        Assertions.assertEquals((double)10.0, (Double)((Double)this.range1.getMinimum()));
    }

    @Test
    void testHashCode() {
        Assertions.assertEquals((int)this.range1.hashCode(), (int)this.range2.hashCode());
        Assertions.assertNotEquals((int)this.range1.hashCode(), (int)this.range3.hashCode());
        Assertions.assertEquals((int)this.range1.hashCode(), (int)this.range1.hashCode());
        Assertions.assertTrue((this.range1.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    void testIntersectionWith() {
        Assertions.assertSame((Object)this.range1, (Object)this.range1.intersectionWith((Range)this.range1));
        Assertions.assertEquals((Object)Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(15.0)), (Object)this.range1.intersectionWith(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(15.0))));
    }

    @Test
    void testIntersectionWithNonOverlapping() {
        LangAssertions.assertIllegalArgumentException(() -> this.range1.intersectionWith(Range.of((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(9.0))));
    }

    @Test
    void testIntersectionWithNull() {
        LangAssertions.assertIllegalArgumentException(() -> this.range1.intersectionWith(null));
    }

    @Test
    void testIsAfter() {
        Assertions.assertFalse((boolean)this.range1.isAfter(null));
        Assertions.assertTrue((boolean)this.range1.isAfter((Object)5.0));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)10.0));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)15.0));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)20.0));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)25.0));
    }

    @Test
    void testIsAfterRange() {
        Assertions.assertFalse((boolean)this.range1.isAfterRange(null));
        Assertions.assertTrue((boolean)this.range1.isAfterRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(9.0))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(10.0))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(25.0))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Double.valueOf(15.0), (Comparable)Double.valueOf(25.0))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Double.valueOf(21.0), (Comparable)Double.valueOf(25.0))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0))));
    }

    @Test
    void testIsBefore() {
        Assertions.assertFalse((boolean)this.range1.isBefore(null));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)5.0));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)10.0));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)15.0));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)20.0));
        Assertions.assertTrue((boolean)this.range1.isBefore((Object)25.0));
    }

    @Test
    void testIsBeforeIntegerRange() {
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(null));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)DoubleRangeTest.of(5.0, 9.0)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)DoubleRangeTest.of(5.0, 10.0)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)DoubleRangeTest.of(5.0, 20.0)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)DoubleRangeTest.of(5.0, 25.0)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)DoubleRangeTest.of(15.0, 25.0)));
        Assertions.assertTrue((boolean)this.range1.isBeforeRange((Range)DoubleRangeTest.of(21.0, 25.0)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)DoubleRangeTest.of(10.0, 20.0)));
    }

    @Test
    void testIsBeforeRange() {
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(null));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(9.0))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(10.0))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Double.valueOf(5.0), (Comparable)Double.valueOf(25.0))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Double.valueOf(15.0), (Comparable)Double.valueOf(25.0))));
        Assertions.assertTrue((boolean)this.range1.isBeforeRange(Range.of((Comparable)Double.valueOf(21.0), (Comparable)Double.valueOf(25.0))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0))));
    }

    @Test
    void testIsEndedBy() {
        Assertions.assertFalse((boolean)this.range1.isEndedBy(null));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)5.0));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)10.0));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)15.0));
        Assertions.assertTrue((boolean)this.range1.isEndedBy((Object)20.0));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)25.0));
    }

    @Test
    void testIsOverlappedByIntegerRange() {
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(null));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(12.0, 18.0)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(32.0, 45.0)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(2.0, 8.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(10.0, 20.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(9.0, 14.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(16.0, 21.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(10.0, 19.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(10.0, 21.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(11.0, 20.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(9.0, 20.0)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(-11.0, -18.0)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)DoubleRangeTest.of(9.0, 21.0)));
    }

    @Test
    void testIsOverlappedByRange() {
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(null));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(12.0), (Comparable)Double.valueOf(18.0))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(32.0), (Comparable)Double.valueOf(45.0))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(2.0), (Comparable)Double.valueOf(8.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(9.0), (Comparable)Double.valueOf(14.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(16.0), (Comparable)Double.valueOf(21.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(19.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(21.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(11.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(9.0), (Comparable)Double.valueOf(20.0))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(-11.0), (Comparable)Double.valueOf(-18.0))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Double.valueOf(9.0), (Comparable)Double.valueOf(21.0))));
    }

    @Test
    void testIsStartedBy() {
        Assertions.assertFalse((boolean)this.range1.isStartedBy(null));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)5.0));
        Assertions.assertTrue((boolean)this.range1.isStartedBy((Object)10.0));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)15.0));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)20.0));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)25.0));
    }

    @Test
    void testIsWithCompareRange() {
        Comparator c = (o1, o2) -> 0;
        Range ri = Range.is((Comparable)Integer.valueOf(10));
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertFalse((boolean)ri.contains((Object)11), (String)"should not contain 11");
        ri = Range.is((Object)10, (Comparator)c);
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)ri.contains((Object)11), (String)"should contain 11");
    }

    @Test
    void testOfWithContains() {
        DoubleRange rb = DoubleRangeTest.of(-10.0, 20.0);
        Assertions.assertFalse((boolean)rb.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rb.contains((Object)10.0), (String)"should contain 10");
        Assertions.assertTrue((boolean)rb.contains((Object)-10.0), (String)"should contain -10");
        Assertions.assertFalse((boolean)rb.contains((Object)21.0), (String)"should not contain 21");
        Assertions.assertFalse((boolean)rb.contains((Object)-11.0), (String)"should not contain -11");
        LangAssertions.assertNullPointerException(() -> DoubleRangeTest.of(null, null));
    }

    @Test
    void testRangeOfChars() {
        DoubleRange chars = DoubleRangeTest.of(97.0, 122.0);
        Assertions.assertTrue((boolean)chars.contains((Object)98.0));
        Assertions.assertFalse((boolean)chars.contains((Object)66.0));
    }

    @Test
    void testSerializing() {
        SerializationUtils.clone((Serializable)this.range1);
    }

    @Test
    void testToString() {
        Assertions.assertNotNull((Object)this.range1.toString());
        String str = this.range1.toString();
        Assertions.assertEquals((Object)"[10.0..20.0]", (Object)str);
        Assertions.assertEquals((Object)"[-20.0..-10.0]", (Object)Range.of((Comparable)Double.valueOf(-20.0), (Comparable)Double.valueOf(-10.0)).toString());
        Assertions.assertEquals((Object)"[-20.0..-10.0]", (Object)DoubleRange.of((double)-20.0, (double)-10.0).toString());
    }

    @Test
    void testToStringFormat() {
        String str = this.range1.toString("From %1$s to %2$s");
        Assertions.assertEquals((Object)"From 10.0 to 20.0", (Object)str);
    }
}

