/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import java.io.EOFException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;

public class EncryptedMessageWithHeader
implements ChunkedInput<ByteBuf> {
    @Nullable
    private final ManagedBuffer managedBuffer;
    private final ByteBuf header;
    private final int headerLength;
    private final Object body;
    private final long bodyLength;
    private long totalBytesTransferred;

    public EncryptedMessageWithHeader(@Nullable ManagedBuffer managedBuffer, ByteBuf header, Object body, long bodyLength) {
        Preconditions.checkArgument((body instanceof InputStream || body instanceof ChunkedStream ? 1 : 0) != 0, (Object)"Body must be an InputStream or a ChunkedStream.");
        this.managedBuffer = managedBuffer;
        this.header = header;
        this.headerLength = header.readableBytes();
        this.body = body;
        this.bodyLength = bodyLength;
        this.totalBytesTransferred = 0L;
    }

    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        if (this.totalBytesTransferred < (long)this.headerLength) {
            this.totalBytesTransferred += (long)this.headerLength;
            return this.header.retain();
        }
        if (this.body instanceof InputStream) {
            int toRead;
            InputStream stream = (InputStream)this.body;
            int available = stream.available();
            available = available <= 0 ? (int)(this.length() - this.totalBytesTransferred) : (int)Math.min((long)available, this.length() - this.totalBytesTransferred);
            ByteBuf buffer = allocator.buffer(available);
            int read = buffer.writeBytes(stream, toRead = Math.min(available, buffer.writableBytes()));
            if (read >= 0) {
                this.totalBytesTransferred += (long)read;
                return buffer;
            }
            throw new EOFException("Unable to read bytes from InputStream");
        }
        if (this.body instanceof ChunkedStream) {
            ChunkedStream stream = (ChunkedStream)this.body;
            long old = stream.transferredBytes();
            ByteBuf buffer = stream.readChunk(allocator);
            long read = stream.transferredBytes() - old;
            if (read >= 0L) {
                this.totalBytesTransferred += read;
                assert (this.totalBytesTransferred <= this.length());
                return buffer;
            }
            throw new EOFException("Unable to read bytes from ChunkedStream");
        }
        return null;
    }

    public long length() {
        return (long)this.headerLength + this.bodyLength;
    }

    public long progress() {
        return this.totalBytesTransferred;
    }

    public boolean isEndOfInput() throws Exception {
        return (long)this.headerLength + this.bodyLength == this.totalBytesTransferred;
    }

    public void close() throws Exception {
        this.header.release();
        if (this.managedBuffer != null) {
            this.managedBuffer.release();
        }
        if (this.body instanceof InputStream) {
            ((InputStream)this.body).close();
        } else if (this.body instanceof ChunkedStream) {
            ((ChunkedStream)this.body).close();
        }
    }
}

