/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http.authentication;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.authentication.AnonymousAuthenticationProviderImpl;
import org.apache.celeborn.common.authentication.DefaultTokenCredential;
import org.apache.celeborn.common.authentication.HttpAuthSchemes$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.server.common.http.HttpAuthUtils$;
import org.apache.celeborn.server.common.http.authentication.AuthenticationHandler;
import org.apache.celeborn.server.common.http.authentication.HttpAuthenticationFactory$;
import org.apache.celeborn.spi.authentication.TokenAuthenticationProvider;
import org.apache.celeborn.spi.authentication.TokenCredential;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\t\u0012\u0001\u0001B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006}\u0001!\ta\u0010\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\n\rC\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\t\u0013=\u0003\u0001\u0019!A!B\u0013!\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007+\u0002\u0001\u000b\u0011\u0002*\t\u000fY\u0003!\u0019!C!/\"1!\u000e\u0001Q\u0001\naCQa\u001b\u0001\u0005B1DQA\u001c\u0001\u0005BECQa\u001c\u0001\u0005BADQa\u001d\u0001\u0005BQDq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\u0012\u0001!\t%a\u0005\u00037\t+\u0017M]3s\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0011\u0006tG\r\\3s\u0015\t\u00112#\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005Q)\u0012\u0001\u00025uiBT!AF\f\u0002\r\r|W.\\8o\u0015\tA\u0012$\u0001\u0004tKJ4XM\u001d\u0006\u00035m\t\u0001bY3mK\n|'O\u001c\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tse\u000b\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!JS\"A\t\n\u0005)\n\"!F!vi\",g\u000e^5dCRLwN\u001c%b]\u0012dWM\u001d\t\u0003YAj\u0011!\f\u0006\u0003]=\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003-eI!!M\u0017\u0003\u000f1{wmZ5oO\u0006i\u0001O]8wS\u0012,'o\u00117bgN\u0004\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c$\u001b\u00059$B\u0001\u001d \u0003\u0019a$o\\8u}%\u0011!hI\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;G\u00051A(\u001b8jiz\"\"\u0001Q!\u0011\u0005!\u0002\u0001\"\u0002\u001a\u0003\u0001\u0004\u0019\u0014\u0001B2p]\u001a,\u0012\u0001\u0012\t\u0003\u000b\u001ak\u0011aL\u0005\u0003\u000f>\u0012AbQ3mK\n|'O\\\"p]\u001a\f\u0001bY8oM~#S-\u001d\u000b\u0003\u00156\u0003\"AI&\n\u00051\u001b#\u0001B+oSRDqA\u0014\u0003\u0002\u0002\u0003\u0007A)A\u0002yIE\nQaY8oM\u0002\na\"\u00197m_^\fen\u001c8z[>,8/F\u0001S!\t\u00113+\u0003\u0002UG\t9!i\\8mK\u0006t\u0017aD1mY><\u0018I\\8os6|Wo\u001d\u0011\u0002\u0015\u0005,H\u000f[*dQ\u0016lW-F\u0001Y!\tIvM\u0004\u0002[I:\u00111l\u0019\b\u00039\nt!!X1\u000f\u0005y\u0003gB\u0001\u001c`\u0013\u0005q\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u0002\u00173%\u0011!cL\u0005\u0003K\u001a\fq\u0002\u0013;ua\u0006+H\u000f[*dQ\u0016lWm\u001d\u0006\u0003%=J!\u0001[5\u0003\u001d!#H\u000f]!vi\"\u001c6\r[3nK*\u0011QMZ\u0001\fCV$\bnU2iK6,\u0007%\u0001\u0003j]&$HC\u0001&n\u0011\u0015\u0011%\u00021\u0001E\u0003]\tW\u000f\u001e5f]RL7-\u0019;j_:\u001cV\u000f\u001d9peR,G-A\bnCR\u001c\u0007.Q;uQN\u001b\u0007.Z7f)\t\u0011\u0016\u000fC\u0003s\u0019\u0001\u00071'A\u0007bkRDwN]5{CRLwN\\\u0001\u0011O\u0016$\u0018)\u001e;i_JL'0\u0019;j_:$\"aM;\t\u000bYl\u0001\u0019A<\u0002\u000fI,\u0017/^3tiB\u0011\u0001P`\u0007\u0002s*\u0011AC\u001f\u0006\u0003wr\fqa]3sm2,GOC\u0001~\u0003\u0015Q\u0017M^1y\u0013\ty\u0018P\u0001\nIiR\u00048+\u001a:wY\u0016$(+Z9vKN$\u0018\u0001D1vi\",g\u000e^5dCR,G#B\u001a\u0002\u0006\u0005\u001d\u0001\"\u0002<\u000f\u0001\u00049\bbBA\u0005\u001d\u0001\u0007\u00111B\u0001\te\u0016\u001c\bo\u001c8tKB\u0019\u00010!\u0004\n\u0007\u0005=\u0011PA\nIiR\u00048+\u001a:wY\u0016$(+Z:q_:\u001cX-A\u0004eKN$(o\\=\u0015\u0003)\u0003")
public class BearerAuthenticationHandler
implements AuthenticationHandler,
Logging {
    private final String providerClass;
    private CelebornConf conf;
    private final boolean allowAnonymous;
    private final Enumeration.Value authScheme;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        BearerAuthenticationHandler bearerAuthenticationHandler = this;
        synchronized (bearerAuthenticationHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private CelebornConf conf() {
        return this.conf;
    }

    private void conf_$eq(CelebornConf x$1) {
        this.conf = x$1;
    }

    private boolean allowAnonymous() {
        return this.allowAnonymous;
    }

    @Override
    public Enumeration.Value authScheme() {
        return this.authScheme;
    }

    @Override
    public void init(CelebornConf conf) {
        this.conf_$eq(conf);
    }

    @Override
    public boolean authenticationSupported() {
        return Option$.MODULE$.apply((Object)this.providerClass).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BearerAuthenticationHandler.$anonfun$authenticationSupported$1(this, x$1)));
    }

    @Override
    public boolean matchAuthScheme(String authorization) {
        if (authorization == null || authorization.isEmpty()) {
            return this.allowAnonymous();
        }
        return AuthenticationHandler.matchAuthScheme$(this, authorization);
    }

    @Override
    public String getAuthorization(HttpServletRequest request) {
        String authHeader = request.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
        if (this.allowAnonymous() && (authHeader == null || authHeader.isEmpty())) {
            return "";
        }
        return AuthenticationHandler.getAuthorization$(this, request);
    }

    @Override
    public String authenticate(HttpServletRequest request, HttpServletResponse response) {
        String principal = null;
        String inputToken = this.getAuthorization(request);
        if (!this.allowAnonymous() && StringUtils.isBlank((CharSequence)inputToken)) {
            response.setHeader(HttpAuthUtils$.MODULE$.WWW_AUTHENTICATE_HEADER(), this.authScheme().toString());
            response.setStatus(401);
        } else {
            DefaultTokenCredential credential = new DefaultTokenCredential(inputToken, HttpAuthUtils$.MODULE$.getCredentialExtraInfo());
            principal = HttpAuthenticationFactory$.MODULE$.getTokenAuthenticationProvider(this.providerClass, this.conf()).authenticate((TokenCredential)credential).getName();
            response.setStatus(200);
        }
        return principal;
    }

    @Override
    public void destroy() {
    }

    public static final /* synthetic */ boolean $anonfun$authenticationSupported$1(BearerAuthenticationHandler $this, String x$1) {
        boolean bl;
        try {
            Class.forName($this.providerClass).isAssignableFrom(TokenAuthenticationProvider.class);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public BearerAuthenticationHandler(String providerClass) {
        this.providerClass = providerClass;
        AuthenticationHandler.$init$(this);
        Logging.$init$((Logging)this);
        String string = AnonymousAuthenticationProviderImpl.class.getName();
        String string2 = providerClass;
        this.allowAnonymous = !(string != null ? !string.equals(string2) : string2 != null);
        this.authScheme = HttpAuthSchemes$.MODULE$.BEARER();
    }
}

